/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.objects;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.dbxml.Debug;
import org.dbxml.core.objects.Args;
import org.dbxml.core.objects.ClassFormatException;
import org.dbxml.core.objects.ElementArgs;
import org.dbxml.core.objects.MethodNotFoundException;
import org.dbxml.core.objects.Reflectable;
import org.dbxml.core.objects.Types;
import org.dbxml.core.objects.Variant;
import org.dbxml.core.objects.XMLObjectException;
import org.dbxml.core.objects.XMLObjectRuntimeException;
import org.w3c.dom.Element;

public final class Reflector {
    private static final String[] EmptyStrings = new String[0];
    private static final String PARAMS_PREFIX = "PARAMS_";
    private static final String DEFAULTS_PREFIX = "DEFAULTS_";
    private static final String ERRORS_PREFIX = "ERRORS_";
    private Map methods = new HashMap();
    static /* synthetic */ Class class$org$dbxml$core$objects$SimpleXMLObject;
    static /* synthetic */ Class class$org$dbxml$core$objects$SimpleReflectable;
    static /* synthetic */ Class class$java$lang$String;

    public Reflector() {
    }

    public Reflector(Class clazz) throws XMLObjectException {
        this.reflect(clazz);
    }

    public void reflect(Class clazz) throws XMLObjectException {
        if (clazz == (class$org$dbxml$core$objects$SimpleXMLObject == null ? (class$org$dbxml$core$objects$SimpleXMLObject = Reflector.class$("org.dbxml.core.objects.SimpleXMLObject")) : class$org$dbxml$core$objects$SimpleXMLObject)) {
            return;
        }
        if (clazz == (class$org$dbxml$core$objects$SimpleReflectable == null ? (class$org$dbxml$core$objects$SimpleReflectable = Reflector.class$("org.dbxml.core.objects.SimpleReflectable")) : class$org$dbxml$core$objects$SimpleReflectable)) {
            try {
                String string = "queryInterface";
                Method method = clazz.getMethod(string, new Class[0]);
                MethodInfo methodInfo = new MethodInfo(0, string, method, new ParamInfo[0]);
                this.methods.put(string, methodInfo);
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
            return;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < methodArray.length) {
            Class<?> clazz2;
            int n2;
            String string = methodArray[n].getName();
            int n3 = methodArray[n].getModifiers();
            if (!(!Modifier.isPublic(n3) || Modifier.isStatic(n3) || (n2 = Types.typeOf(clazz2 = methodArray[n].getReturnType())) == -1 || clazz2.isArray() || (string.startsWith("get") || string.startsWith("set")) && (string.equals("getReflector") || string.equals("getName") || string.equals("setDatabase") || string.equals("getDatabase") || string.equals("setDatabase") || string.equals("getDatabase") || string.equals("setCollection") || string.equals("getCollection") || string.equals("setContainer") || string.equals("getContainer") || string.equals("setDocument") || string.equals("getDocument") || string.equals("setConfig") || string.equals("getConfig") || string.equals("setPool")) || string.equals("reclaim") || string.equals("equals") || string.equals("finalize") || string.equals("hashCode") || string.equals("notify") || string.equals("notifyAll") || string.equals("wait"))) {
                if (hashSet.contains(string)) {
                    throw new ClassFormatException("Duplicate Exposed Method '" + string + "'");
                }
                Class<?>[] classArray = methodArray[n].getParameterTypes();
                ParamInfo[] paramInfoArray = new ParamInfo[classArray.length];
                String[] stringArray = this.getFieldVals(clazz, classArray.length, PARAMS_PREFIX + string);
                String[] stringArray2 = this.getFieldVals(clazz, classArray.length, DEFAULTS_PREFIX + string);
                String[] stringArray3 = this.getFieldVals(clazz, classArray.length, ERRORS_PREFIX + string);
                boolean bl = true;
                int n4 = 0;
                while (n4 < classArray.length && bl) {
                    String string2 = stringArray != null ? stringArray[n4] : "arg" + (n4 + 1);
                    int n5 = Types.typeOf(classArray[n4]);
                    bl = n5 != -1;
                    paramInfoArray[n4] = classArray[n4].isArray() ? new ParamInfo(string2, n5, classArray[n4].getComponentType()) : new ParamInfo(string2, n5);
                    if (stringArray2 != null) {
                        paramInfoArray[n4].defValue = stringArray2[n4];
                    }
                    if (stringArray3 != null) {
                        paramInfoArray[n4].errValue = stringArray3[n4];
                    }
                    ++n4;
                }
                if (bl) {
                    this.methods.put(string, new MethodInfo(n2, string, methodArray[n], paramInfoArray));
                    hashSet.add(string);
                }
            }
            ++n;
        }
    }

    private String[] getFieldVals(Class clazz, int n, String string) {
        try {
            String[] stringArray;
            Field field = clazz.getDeclaredField(string);
            int n2 = field.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2) && field.getType().isArray() && field.getType().getComponentType() == (class$java$lang$String == null ? (class$java$lang$String = Reflector.class$("java.lang.String")) : class$java$lang$String) && (stringArray = (String[])field.get(null)).length == n) {
                return stringArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMethod(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) throws XMLObjectException {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo == null) throw new MethodNotFoundException("Method '" + string + "' Not Found");
        if (methodInfo.params.length != stringArray.length) throw new ClassFormatException("Param Count For '" + string + "' Does Not Match Reflector");
        int n = 0;
        while (n < stringArray.length) {
            methodInfo.params[n].name = stringArray[n];
            if (stringArray2 != null) {
                methodInfo.params[n].defValue = stringArray2[n];
            }
            if (stringArray3 != null) {
                methodInfo.params[n].errValue = stringArray3[n];
            }
            ++n;
        }
    }

    public void addMethod(String string, String[] stringArray) throws XMLObjectException {
        this.addMethod(string, stringArray, null, null);
    }

    public void addMethod(String string, String[] stringArray, String[] stringArray2) throws XMLObjectException {
        this.addMethod(string, stringArray, stringArray2, null);
    }

    public String[] listMethods() {
        return this.methods.keySet().toArray(EmptyStrings);
    }

    public String[] listMethodParams(String string) {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        String[] stringArray = null;
        if (methodInfo != null) {
            stringArray = new String[methodInfo.params.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = methodInfo.params[n].name;
                if (stringArray[n] == null) {
                    return null;
                }
                ++n;
            }
        }
        return stringArray;
    }

    public int getReturnType(String string) {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            return methodInfo.result;
        }
        return -1;
    }

    public int getParamType(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            int n = 0;
            while (n < methodInfo.params.length) {
                if (methodInfo.params[n].name.equals(string2)) {
                    return methodInfo.params[n].type;
                }
                ++n;
            }
        }
        return -1;
    }

    public String getParamDefault(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            int n = 0;
            while (n < methodInfo.params.length) {
                if (methodInfo.params[n].name.equals(string2)) {
                    return methodInfo.params[n].defValue;
                }
                ++n;
            }
        }
        return null;
    }

    public boolean isParamArray(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            int n = 0;
            while (n < methodInfo.params.length) {
                if (methodInfo.params[n].name.equals(string2)) {
                    return methodInfo.params[n].array;
                }
                ++n;
            }
        }
        return false;
    }

    public Object invoke(Reflectable reflectable, String string, Object[] objectArray) throws XMLObjectException {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            try {
                return methodInfo.method.invoke((Object)reflectable, objectArray);
            }
            catch (Exception exception) {
                throw new XMLObjectRuntimeException("Error Invoking Method '" + string + "'");
            }
        }
        throw new MethodNotFoundException("Method '" + string + "' Not Found");
    }

    private boolean isTrue(String string) {
        return "[true][yes][1][y][on]".indexOf("[" + string.toLowerCase() + "]") != -1;
    }

    public Object invoke(Reflectable reflectable, String string, Variant[] variantArray) throws XMLObjectException {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            Object[] objectArray = new Object[methodInfo.params.length];
            int n = 0;
            while (n < methodInfo.params.length) {
                ParamInfo paramInfo = methodInfo.params[n];
                if (variantArray[n] == null) {
                    variantArray[n] = new Variant(paramInfo.defValue);
                }
                if (!paramInfo.array) {
                    switch (paramInfo.type) {
                        case 11: {
                            objectArray[n] = variantArray[n].getString();
                            break;
                        }
                        case 6: {
                            objectArray[n] = new Long(variantArray[n].getLong());
                            break;
                        }
                        case 5: {
                            objectArray[n] = new Integer(variantArray[n].getInt());
                            break;
                        }
                        case 4: {
                            objectArray[n] = new Short(variantArray[n].getShort());
                            break;
                        }
                        case 2: {
                            objectArray[n] = new Byte(variantArray[n].getByte());
                            break;
                        }
                        case 3: {
                            objectArray[n] = new Character(variantArray[n].getChar());
                            break;
                        }
                        case 7: {
                            objectArray[n] = new Float(variantArray[n].getFloat());
                            break;
                        }
                        case 8: {
                            objectArray[n] = new Double(variantArray[n].getDouble());
                            break;
                        }
                        case 1: {
                            objectArray[n] = new Boolean(variantArray[n].getBoolean());
                            break;
                        }
                        case 15: {
                            objectArray[n] = variantArray[n].getObject();
                            break;
                        }
                        case 20: {
                            objectArray[n] = variantArray[n];
                        }
                    }
                } else {
                    Class clazz = paramInfo.component;
                    StringTokenizer stringTokenizer = new StringTokenizer(variantArray[n].getString(), "\u0001");
                    int n2 = stringTokenizer.countTokens();
                    Object object = Array.newInstance(clazz, n2);
                    switch (paramInfo.type) {
                        case 11: {
                            int n3 = 0;
                            while (n3 < n2) {
                                Array.set(object, n3, stringTokenizer.nextToken());
                                ++n3;
                            }
                            break;
                        }
                        case 6: {
                            int n4 = 0;
                            while (n4 < n2) {
                                Array.setLong(object, n4, Long.parseLong(stringTokenizer.nextToken()));
                                ++n4;
                            }
                            break;
                        }
                        case 5: {
                            int n5 = 0;
                            while (n5 < n2) {
                                Array.setInt(object, n5, Integer.parseInt(stringTokenizer.nextToken()));
                                ++n5;
                            }
                            break;
                        }
                        case 4: {
                            int n6 = 0;
                            while (n6 < n2) {
                                Array.setShort(object, n6, Short.parseShort(stringTokenizer.nextToken()));
                                ++n6;
                            }
                            break;
                        }
                        case 2: {
                            int n7 = 0;
                            while (n7 < n2) {
                                Array.setByte(object, n7, Byte.parseByte(stringTokenizer.nextToken()));
                                ++n7;
                            }
                            break;
                        }
                        case 3: {
                            int n8 = 0;
                            while (n8 < n2) {
                                Array.setChar(object, n8, stringTokenizer.nextToken().charAt(0));
                                ++n8;
                            }
                            break;
                        }
                        case 7: {
                            int n9 = 0;
                            while (n9 < n2) {
                                Array.setFloat(object, n9, Float.parseFloat(stringTokenizer.nextToken()));
                                ++n9;
                            }
                            break;
                        }
                        case 8: {
                            int n10 = 0;
                            while (n10 < n2) {
                                Array.setDouble(object, n10, Double.parseDouble(stringTokenizer.nextToken()));
                                ++n10;
                            }
                            break;
                        }
                        case 1: {
                            int n11 = 0;
                            while (n11 < n2) {
                                Array.setBoolean(object, n11, this.isTrue(stringTokenizer.nextToken()));
                                ++n11;
                            }
                            break;
                        }
                        case 20: {
                            int n12 = 0;
                            while (n12 < n2) {
                                Array.set(object, n12, new Variant(stringTokenizer.nextToken()));
                                ++n12;
                            }
                            break;
                        }
                    }
                    objectArray[n] = object;
                }
                ++n;
            }
            try {
                return methodInfo.method.invoke((Object)reflectable, objectArray);
            }
            catch (Exception exception) {
                throw new XMLObjectRuntimeException("Error Invoking Method '" + string + "'");
            }
        }
        throw new MethodNotFoundException("Method '" + string + "' Not Found");
    }

    public Object invoke(Reflectable reflectable, String string, Args args) throws XMLObjectException {
        MethodInfo methodInfo = (MethodInfo)this.methods.get(string);
        if (methodInfo != null) {
            Variant[] variantArray = new Variant[methodInfo.params.length];
            int n = 0;
            while (n < methodInfo.params.length) {
                variantArray[n] = methodInfo.params[n].type == 15 ? new Variant(args) : args.get(methodInfo.params[n].name);
                ++n;
            }
            return this.invoke(reflectable, string, variantArray);
        }
        throw new MethodNotFoundException("Method '" + string + "' Not Found");
    }

    public Object invoke(Reflectable reflectable, String string, Element element) throws XMLObjectException {
        return this.invoke(reflectable, string, new ElementArgs(element));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MethodInfo {
        public int result;
        public String name;
        public Method method;
        public ParamInfo[] params;

        public MethodInfo(int n, String string, Method method, ParamInfo[] paramInfoArray) {
            this.result = n;
            this.name = string;
            this.method = method;
            this.params = paramInfoArray;
        }
    }

    private class ParamInfo {
        public Class component;
        public int type;
        public boolean array;
        public String name = null;
        public String defValue = null;
        public String errValue = null;

        public ParamInfo(String string, int n, Class clazz) {
            this.name = string;
            this.type = n;
            this.component = clazz;
            this.array = true;
        }

        public ParamInfo(String string, int n) {
            this.name = string;
            this.type = n;
            this.component = null;
            this.array = false;
        }
    }
}

