/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.objects;

import java.util.HashMap;
import java.util.Map;
import org.dbxml.Debug;
import org.dbxml.core.objects.Reflectable;
import org.dbxml.core.objects.Reflector;
import org.dbxml.core.objects.Types;
import org.dbxml.server.Configuration;
import org.dbxml.server.ObjectPool;
import org.dbxml.server.Poolable;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleReflectable
extends SimpleConfigurable
implements Reflectable,
Poolable {
    private static final String NAME = "name";
    private static final String PACKAGE = "package";
    private static final String CLASS = "class";
    private static final String METHOD = "method";
    private static final String PARAM = "param";
    private static final String TYPE = "type";
    private static final String DEFAULT = "default";
    private static Map metaCache = new HashMap();
    private Document intf = null;
    protected ObjectPool pool = null;
    protected Reflector meta = null;
    protected String name = null;
    static /* synthetic */ Class class$org$dbxml$core$objects$SimpleReflectable;

    public SimpleReflectable() {
        try {
            Class<?> clazz = this.getClass();
            this.meta = (Reflector)metaCache.get(clazz);
            if (this.meta == null) {
                this.meta = new Reflector();
                this.reflect(this.getClass());
                metaCache.put(clazz, this.meta);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    private void reflect(Class clazz) throws Exception {
        if (clazz != (class$org$dbxml$core$objects$SimpleReflectable == null ? (class$org$dbxml$core$objects$SimpleReflectable = SimpleReflectable.class$("org.dbxml.core.objects.SimpleReflectable")) : class$org$dbxml$core$objects$SimpleReflectable)) {
            this.reflect(clazz.getSuperclass());
        }
        this.meta.reflect(clazz);
    }

    private String trimClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        this.name = configuration.getAttribute(NAME);
    }

    public Reflector getReflector() {
        return this.meta;
    }

    public void setPool(ObjectPool objectPool) {
        this.pool = objectPool;
    }

    public void reclaim() {
        if (this.pool != null) {
            this.pool.putObject((Poolable)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public Document queryInterface() {
        if (this.intf == null) {
            this.intf = new DocumentImpl();
            String[] stringArray = this.meta.listMethods();
            String string = this.name != null ? this.name : this.trimClassName(this.getClass().getName());
            Element element = this.intf.createElement(CLASS);
            element.setAttribute(NAME, string);
            element.setAttribute(PACKAGE, this.getClass().getPackage().getName().replace('.', '/'));
            this.intf.appendChild(element);
            int n = 0;
            while (n < stringArray.length) {
                String string2 = Types.typeName(this.meta.getReturnType(stringArray[n]));
                Element element2 = this.intf.createElement(METHOD);
                element2.setAttribute(NAME, stringArray[n]);
                element2.setAttribute(TYPE, string2);
                element.appendChild(element2);
                String[] stringArray2 = this.meta.listMethodParams(stringArray[n]);
                int n2 = 0;
                while (stringArray2 != null && n2 < stringArray2.length) {
                    string2 = Types.typeName(this.meta.getParamType(stringArray[n], stringArray2[n2]));
                    String string3 = this.meta.getParamDefault(stringArray[n], stringArray2[n2]);
                    if (this.meta.isParamArray(stringArray[n], stringArray2[n2])) {
                        string2 = string2 + "[]";
                    }
                    Element element3 = this.intf.createElement(PARAM);
                    element3.setAttribute(NAME, stringArray2[n2]);
                    element3.setAttribute(TYPE, string2);
                    if (string3 != null) {
                        element3.setAttribute(DEFAULT, string3);
                    }
                    element2.appendChild(element3);
                    ++n2;
                }
                ++n;
            }
        }
        return this.intf;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

