/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.objects;

import org.dbxml.core.objects.Args;
import org.dbxml.xml.TextWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Variant {
    private Object value = null;
    private int type = -1;

    public Variant() {
    }

    public Variant(Variant variant) {
        this.value = variant.value;
        this.type = variant.type;
    }

    public Variant(String string) {
        this.value = string;
        this.type = 11;
    }

    public Variant(boolean bl) {
        this.value = new Boolean(bl);
        this.type = 1;
    }

    public Variant(byte by) {
        this.value = new Byte(by);
        this.type = 2;
    }

    public Variant(char c) {
        this.value = new Character(c);
        this.type = 3;
    }

    public Variant(short s) {
        this.value = new Short(s);
        this.type = 4;
    }

    public Variant(int n) {
        this.value = new Integer(n);
        this.type = 5;
    }

    public Variant(long l) {
        this.value = new Long(l);
        this.type = 6;
    }

    public Variant(float f) {
        this.value = new Float(f);
        this.type = 7;
    }

    public Variant(double d) {
        this.value = new Double(d);
        this.type = 8;
    }

    public Variant(Element element) {
        this.value = element;
        this.type = 12;
    }

    public Variant(Document document) {
        this.value = document;
        this.type = 13;
    }

    public Variant(DocumentFragment documentFragment) {
        this.value = documentFragment;
        this.type = 14;
    }

    public Variant(Args args) {
        this.value = args;
        this.type = 15;
    }

    public Variant(Object object) {
        this.value = object;
        this.type = 10;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void set(String string) {
        this.value = string;
        this.type = 11;
    }

    public void set(boolean bl) {
        this.value = new Boolean(bl);
        this.type = 1;
    }

    public void set(byte by) {
        this.value = new Byte(by);
        this.type = 2;
    }

    public void set(char c) {
        this.value = new Character(c);
        this.type = 3;
    }

    public void set(short s) {
        this.value = new Short(s);
        this.type = 4;
    }

    public void set(int n) {
        this.value = new Integer(n);
        this.type = 5;
    }

    public void set(long l) {
        this.value = new Long(l);
        this.type = 6;
    }

    public void set(float f) {
        this.value = new Float(f);
        this.type = 7;
    }

    public void set(double d) {
        this.value = new Double(d);
        this.type = 8;
    }

    public void set(Element element) {
        this.value = element;
        this.type = 12;
    }

    public void set(Document document) {
        this.value = document;
        this.type = 13;
    }

    public void set(DocumentFragment documentFragment) {
        this.value = documentFragment;
        this.type = 14;
    }

    public void set(Args args) {
        this.value = args;
        this.type = 15;
    }

    public void set(Object object) {
        this.value = this.value;
        this.type = this.value != null ? 10 : -1;
    }

    public String getString() {
        if (this.type == 11) {
            return (String)this.value;
        }
        return this.value.toString();
    }

    public boolean getBoolean() {
        if (this.type == 1) {
            return (Boolean)this.value;
        }
        return "[true][yes][1][y][on]".indexOf("[" + this.value.toString().toLowerCase() + "]") != -1;
    }

    public byte getByte() {
        if (this.type == 2) {
            return (Byte)this.value;
        }
        return Byte.parseByte(this.value.toString());
    }

    public char getChar() {
        if (this.type == 3) {
            return ((Character)this.value).charValue();
        }
        return this.value.toString().charAt(0);
    }

    public short getShort() {
        if (this.type == 4) {
            return (Short)this.value;
        }
        return Short.parseShort(this.value.toString());
    }

    public int getInt() {
        if (this.type == 5) {
            return (Integer)this.value;
        }
        return Integer.parseInt(this.value.toString());
    }

    public long getLong() {
        if (this.type == 6) {
            return (Long)this.value;
        }
        return Long.parseLong(this.value.toString());
    }

    public float getFloat() {
        if (this.type == 7) {
            return ((Float)this.value).floatValue();
        }
        return Float.parseFloat(this.value.toString());
    }

    public double getDouble() {
        if (this.type == 8) {
            return (Double)this.value;
        }
        return Double.parseDouble(this.value.toString());
    }

    public Element getElement() {
        if (this.type == 12) {
            return (Element)this.value;
        }
        return null;
    }

    public Document getDocument() {
        if (this.type == 13) {
            return (Document)this.value;
        }
        return null;
    }

    public DocumentFragment getDocumentFragment() {
        if (this.type == 14) {
            return (DocumentFragment)this.value;
        }
        return null;
    }

    public Args getArgs() {
        if (this.type == 15) {
            return (Args)this.value;
        }
        return null;
    }

    public Object getObject() {
        return this.value;
    }

    public String toString() {
        switch (this.type) {
            case 12: 
            case 13: 
            case 14: {
                return TextWriter.toString((Node)this.value);
            }
        }
        return this.value.toString();
    }
}

