/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.objects;

import java.util.HashMap;
import java.util.Map;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.objects.CannotCreateException;
import org.dbxml.core.objects.DuplicateObjectException;
import org.dbxml.core.objects.InvalidContextException;
import org.dbxml.core.objects.ThreadPolicy;
import org.dbxml.core.objects.XMLObject;
import org.dbxml.server.Configuration;
import org.dbxml.server.ConfigurationCallback;
import org.dbxml.server.ObjectPool;
import org.dbxml.server.Poolable;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;

public final class XMLObjectManager
extends SimpleConfigurable {
    private static final String XMLOBJECTS = "xmlobjects";
    private static final String XMLOBJECT = "xmlobject";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String[] EmptyStrings = new String[0];
    private Map objects = new HashMap();
    private Collection collection;

    public XMLObjectManager(Collection collection) {
        this.collection = collection;
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        configuration.processChildren(XMLOBJECT, new ConfigurationCallback(){

            public void process(Configuration configuration) {
                String string = configuration.getAttribute(XMLObjectManager.CLASS);
                try {
                    XMLObjectManager.this.register(Class.forName(string), configuration);
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        });
    }

    public String[] list() {
        return this.objects.keySet().toArray(EmptyStrings);
    }

    public boolean drop(final String string) {
        this.unregister(string);
        this.config.processChildren(XMLOBJECT, new ConfigurationCallback(){

            public void process(Configuration configuration) {
                try {
                    if (configuration.getAttribute(XMLObjectManager.NAME).equals(string)) {
                        configuration.delete();
                    }
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        });
        return true;
    }

    public XMLObject create(Configuration configuration) throws DBException {
        String string = configuration.getAttribute(CLASS);
        try {
            String string2 = configuration.getAttribute(NAME);
            Configuration[] configurationArray = this.config.getChildren();
            int n = 0;
            while (n < configurationArray.length) {
                if (configurationArray[n].getAttribute(NAME).equals(string2)) {
                    throw new DuplicateObjectException("Duplicate XMLObject '" + string2 + "'");
                }
                ++n;
            }
            Class<?> clazz = Class.forName(string);
            XMLObject xMLObject = this.register(clazz, configuration);
            this.config.add(configuration);
            return xMLObject;
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            throw new CannotCreateException("Cannot create XMLObject");
        }
    }

    public XMLObject register(Class clazz, Configuration configuration) throws DBException {
        String string = null;
        try {
            XMLObject xMLObject = (XMLObject)clazz.newInstance();
            this.initialize(xMLObject, configuration);
            string = xMLObject.getName();
            if (string == null || string.trim().equals("")) {
                throw new CannotCreateException("No name specified");
            }
            int n = 0;
            if (xMLObject instanceof ThreadPolicy) {
                n = ((ThreadPolicy)((Object)xMLObject)).getThreadPolicy();
            }
            this.objects.put(string, new XMLObjectInfo(string, xMLObject, configuration, n));
            return xMLObject;
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            throw new InvalidContextException("'" + string + "' is not a valid XMLObject");
        }
    }

    public void unregister(String string) {
        this.objects.remove(string);
    }

    private void initialize(XMLObject xMLObject, Configuration configuration) throws dbXMLException {
        xMLObject.setConfig(configuration);
        xMLObject.setCollection(this.collection);
    }

    public XMLObject get(String string) {
        XMLObject xMLObject = null;
        try {
            XMLObjectInfo xMLObjectInfo = (XMLObjectInfo)((Object)this.objects.get(string));
            switch (xMLObjectInfo.policy) {
                case 2: {
                    xMLObject = (XMLObject)xMLObjectInfo.c.newInstance();
                    this.initialize(xMLObject, xMLObjectInfo.cfg);
                    break;
                }
                case 1: {
                    xMLObject = (XMLObject)xMLObjectInfo.getObject();
                    break;
                }
                case 0: {
                    xMLObject = xMLObjectInfo.instance;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xMLObject;
    }

    public String getCanonicalName(String string) {
        return this.collection.getCanonicalName() + "/" + string;
    }

    private class XMLObjectInfo
    extends ObjectPool {
        public String name;
        public Class c;
        public int policy;
        public XMLObject instance;
        public Configuration cfg;

        public XMLObjectInfo(String string, XMLObject xMLObject, Configuration configuration, int n) {
            this.name = string;
            this.policy = n;
            this.cfg = configuration;
            switch (n) {
                case 1: {
                    if (!(xMLObject instanceof Poolable)) {
                        n = 2;
                    }
                }
                case 2: {
                    this.c = xMLObject.getClass();
                    break;
                }
                case 0: {
                    this.instance = xMLObject;
                }
            }
        }

        public Poolable createObject() {
            try {
                Poolable poolable = (Poolable)this.c.newInstance();
                XMLObject xMLObject = (XMLObject)poolable;
                XMLObjectManager.this.initialize(xMLObject, this.cfg);
                return poolable;
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
                return null;
            }
        }
    }
}

