/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.Database;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.indexer.IndexMatch;
import org.dbxml.core.query.Query;
import org.dbxml.core.query.QueryException;
import org.dbxml.core.query.QueryResolver;
import org.dbxml.core.query.StyleNotFoundException;
import org.dbxml.server.Configuration;
import org.dbxml.server.ConfigurationCallback;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.NamespaceMap;

public class QueryEngine
extends SimpleConfigurable {
    private static final String[] EmptyStrings = new String[0];
    private static final Key[] EmptyKeys = new Key[0];
    private static final String RESOLVER = "resolver";
    private static final String CLASS = "class";
    private Database db;
    private Map resolvers = new HashMap();

    public QueryEngine(Database database) {
        this.db = database;
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        configuration.processChildren(RESOLVER, new ConfigurationCallback(){

            public void process(Configuration configuration) {
                String string = configuration.getAttribute(QueryEngine.CLASS);
                try {
                    QueryResolver queryResolver = (QueryResolver)Class.forName(string).newInstance();
                    queryResolver.setConfig(configuration);
                    queryResolver.setQueryEngine(QueryEngine.this);
                    QueryEngine.this.resolvers.put(queryResolver.getQueryStyle(), queryResolver);
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        });
    }

    public Database getDatabase() {
        return this.db;
    }

    public String[] listStyles() {
        return this.resolvers.keySet().toArray(EmptyStrings);
    }

    private QueryResolver getResolver(String string) throws QueryException {
        QueryResolver queryResolver = (QueryResolver)this.resolvers.get(string);
        if (queryResolver == null) {
            throw new StyleNotFoundException("No Resolver available for '" + string + "' queries");
        }
        return queryResolver;
    }

    public NodeSet query(Collection collection, String string, String string2, NamespaceMap namespaceMap, Key[] keyArray) throws DBException, QueryException {
        QueryResolver queryResolver = this.getResolver(string);
        return queryResolver.query(collection, string2, namespaceMap, keyArray);
    }

    public Query compileQuery(Collection collection, String string, String string2, NamespaceMap namespaceMap, Key[] keyArray) throws DBException, QueryException {
        QueryResolver queryResolver = this.getResolver(string);
        return queryResolver.compileQuery(collection, string2, namespaceMap, keyArray);
    }

    public static Key[] getUniqueKeys(IndexMatch[] indexMatchArray) {
        TreeSet<Key> treeSet = new TreeSet<Key>();
        int n = 0;
        while (n < indexMatchArray.length) {
            treeSet.add(indexMatchArray[n].getKey());
            ++n;
        }
        return treeSet.toArray(EmptyKeys);
    }

    public static Key[] andKeySets(Key[][] keyArray) {
        if (keyArray.length == 0) {
            return EmptyKeys;
        }
        if (keyArray.length == 1) {
            return keyArray[0];
        }
        if (keyArray.length == 2) {
            if (keyArray[1].length == 0) {
                return keyArray[0];
            }
            if (keyArray[0].length == 0) {
                return keyArray[1];
            }
        }
        TreeSet<Key> treeSet = new TreeSet<Key>();
        int[] nArray = new int[keyArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = 0;
            ++n;
        }
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Key key = null;
        while (!bl) {
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < nArray.length) {
                Key key2 = keyArray[n2][nArray[n2]];
                if (key == null) {
                    key = key2;
                    arrayList.add(new Integer(n2));
                } else {
                    int n3 = key.compareTo(key2);
                    if (n3 != 0) {
                        bl2 = false;
                    }
                    if (n3 < 0) {
                        key = key2;
                        arrayList.clear();
                        arrayList.add(new Integer(n2));
                    } else if (n3 == 0) {
                        arrayList.add(new Integer(n2));
                    }
                }
                ++n2;
            }
            if (bl2) {
                treeSet.add(key);
                arrayList.clear();
                key = null;
            }
            int n4 = 0;
            while (n4 < nArray.length) {
                if (!arrayList.contains(new Integer(n4))) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                }
                if (nArray[n4] >= keyArray[n4].length) {
                    bl = true;
                }
                ++n4;
            }
            if (bl2) continue;
            arrayList.clear();
        }
        return treeSet.toArray(EmptyKeys);
    }

    public static Key[] orKeySets(Key[][] keyArray) {
        if (keyArray.length == 0) {
            return EmptyKeys;
        }
        if (keyArray.length == 1) {
            return keyArray[0];
        }
        if (keyArray.length == 2) {
            if (keyArray[1].length == 0) {
                return keyArray[0];
            }
            if (keyArray[0].length == 0) {
                return keyArray[1];
            }
        }
        TreeSet<Key> treeSet = new TreeSet<Key>();
        int n = 0;
        while (n < keyArray.length) {
            int n2 = 0;
            while (n2 < keyArray[n].length) {
                treeSet.add(keyArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        return treeSet.toArray(EmptyKeys);
    }

    public static String normalizeString(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (" \t\n\r".indexOf(cArray[n2]) != -1) {
                if (!bl) {
                    cArray2[n++] = 32;
                    bl = true;
                }
            } else {
                cArray2[n++] = cArray[n2];
                bl = false;
            }
            ++n2;
        }
        if (bl && n > 0) {
            --n;
        }
        return new String(cArray2, 0, n);
    }

    public static String expandEntities(String string) {
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            if (n != -1) {
                int n3;
                if (n > n2) {
                    stringBuffer.append(string.substring(n2, n));
                }
                if ((n3 = string.indexOf(59, n) + 1) == 0) {
                    return string;
                }
                String string2 = string.substring(n + 1, n3 - 1);
                if (string2.equals("apos")) {
                    stringBuffer.append("'");
                } else if (string2.equals("quot")) {
                    stringBuffer.append("\"");
                } else if (string2.equals("amp")) {
                    stringBuffer.append("&");
                } else if (string2.equals("lt")) {
                    stringBuffer.append("<");
                } else if (string2.equals("gt")) {
                    stringBuffer.append(">");
                } else {
                    return string;
                }
                n2 = n3;
                n = string.indexOf(38, n2);
                continue;
            }
            stringBuffer.append(string.substring(n2));
            break;
        }
        return stringBuffer.toString();
    }
}

