/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.query;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.data.Value;
import org.dbxml.core.indexer.IndexManager;
import org.dbxml.core.indexer.IndexMatch;
import org.dbxml.core.indexer.IndexPattern;
import org.dbxml.core.indexer.IndexQuery;
import org.dbxml.core.indexer.Indexer;
import org.dbxml.core.indexer.helpers.IndexQueryANY;
import org.dbxml.core.indexer.helpers.IndexQueryEQ;
import org.dbxml.core.indexer.helpers.IndexQueryGEQ;
import org.dbxml.core.indexer.helpers.IndexQueryGT;
import org.dbxml.core.indexer.helpers.IndexQueryLEQ;
import org.dbxml.core.indexer.helpers.IndexQueryLT;
import org.dbxml.core.indexer.helpers.IndexQueryNEQ;
import org.dbxml.core.indexer.helpers.IndexQuerySW;
import org.dbxml.core.query.CompilationException;
import org.dbxml.core.query.ProcessingException;
import org.dbxml.core.query.Query;
import org.dbxml.core.query.QueryEngine;
import org.dbxml.core.query.QueryException;
import org.dbxml.core.query.QueryResolver;
import org.dbxml.server.Configuration;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.dom.DBDocument;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathQueryResolver
extends SimpleConfigurable
implements QueryResolver {
    private static final Key[] EmptyKeys = new Key[0];
    private static final Key[][] EmptyKeySet = new Key[0][0];
    private static final String WILDCARD = "*";
    private static final String THISNODE = ".";
    private static final String PARENTNODE = "..";
    private static final String AUTOINDEX = "autoindex";
    public static final String STYLE_XPATH = "XPath";
    private static final int[] OpMap = new int[]{-1, 1, -2, 3, -3, 2};
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    private QueryEngine engine;
    private DefaultErrorHandler errorListener = new DefaultErrorHandler();
    private boolean autoIndex = false;

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        this.autoIndex = configuration.getBooleanAttribute(AUTOINDEX, this.autoIndex);
    }

    public String getQueryStyle() {
        return STYLE_XPATH;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.engine = queryEngine;
    }

    public Query compileQuery(Collection collection, String string, NamespaceMap namespaceMap, Key[] keyArray) throws QueryException {
        return new XPathQuery(collection, string, namespaceMap, keyArray);
    }

    public NodeSet query(Collection collection, String string, NamespaceMap namespaceMap, Key[] keyArray) throws QueryException {
        XPathQuery xPathQuery = new XPathQuery(collection, string, namespaceMap, keyArray);
        return xPathQuery.execute();
    }

    private class ResultSet
    implements NodeSet {
        public XPathContext xpc = new XPathContext();
        public Collection context;
        public String query;
        public ErrorListener errors;
        public PrefixResolver pr;
        public XPath xp;
        public Key[] keySet;
        public int keyPos = 0;
        public NodeList nl;
        public int nlPos = 0;
        public int nlSize = 0;
        public Node node;

        public ResultSet(Collection collection, PrefixResolver prefixResolver, Key[] keyArray, String string) {
            this.context = collection;
            this.pr = prefixResolver;
            this.keySet = keyArray;
            this.query = string;
            this.errors = new ErrorListener(this){
                private final /* synthetic */ ResultSet this$1;
                {
                    this.this$1 = resultSet;
                }

                public void fatalError(TransformerException transformerException) {
                    Debug.println((Object)transformerException);
                }

                public void error(TransformerException transformerException) {
                    Debug.println((Object)transformerException);
                }

                public void warning(TransformerException transformerException) {
                    Debug.println((Object)transformerException);
                }
            };
            this.prepareNextNode();
        }

        private void prepareNextNode() {
            this.node = null;
            while (this.keyPos < this.keySet.length) {
                try {
                    PrefixResolver prefixResolver;
                    DBDocument dBDocument = (DBDocument)this.context.getDocument(this.keySet[this.keyPos++]);
                    if (dBDocument == null) continue;
                    Element element = dBDocument.getDocumentElement();
                    if (this.pr == null) {
                        prefixResolver = new PrefixResolverDefault((Node)dBDocument.getDocumentElement());
                        this.xp = new XPath(this.query, null, prefixResolver, 0, this.errors);
                    } else {
                        prefixResolver = this.pr;
                        if (this.xp == null) {
                            this.xp = new XPath(this.query, null, prefixResolver, 0, this.errors);
                        }
                    }
                    this.nl = this.xp.execute(this.xpc, (Node)element, prefixResolver).mutableNodeset();
                    this.nlSize = this.nl.getLength();
                    if (this.nlSize == 0) continue;
                    this.nlPos = 1;
                    this.node = this.nl.item(0);
                    break;
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        }

        public boolean hasMoreNodes() {
            return this.node != null;
        }

        public Node getNextNode() {
            Node node = this.node;
            if (this.nlPos < this.nlSize) {
                this.node = this.nl.item(this.nlPos++);
            } else {
                this.prepareNextNode();
            }
            return node;
        }
    }

    private class NamedKeys {
        public boolean attribute = false;
        public String name;
        public Key[] keys;

        public NamedKeys(String string, boolean bl, Key[] keyArray) {
            this.name = string;
            this.attribute = bl;
            this.keys = keyArray;
        }
    }

    private class XPathQuery
    implements Query {
        public Collection context;
        public IndexManager idxMgr;
        public NamespaceMap nsMap;
        public PrefixResolver pr;
        public SymbolTable symbols;
        public String query;
        public Compiler cmp;
        public XPath xp;
        public Key[] keys;

        public XPathQuery(Collection collection, String string, NamespaceMap namespaceMap, Key[] keyArray) throws QueryException {
            this.context = collection;
            this.query = string;
            this.nsMap = namespaceMap;
            this.keys = keyArray;
            Expression expression = null;
            try {
                Node node;
                if (namespaceMap != null) {
                    node = namespaceMap.getContextNode();
                    this.pr = new PrefixResolverDefault(node);
                }
                node = new XPathParser((ErrorListener)XPathQueryResolver.this.errorListener, null);
                this.cmp = new Compiler((ErrorListener)XPathQueryResolver.this.errorListener, null);
                node.initXPath(this.cmp, string, this.pr);
                expression = this.cmp.compile(0);
                this.symbols = collection.getSymbols();
                this.idxMgr = collection.getIndexManager();
            }
            catch (Exception exception) {
                throw new CompilationException("Error Compiling XPath Expression");
            }
            if (expression == null) {
                throw new CompilationException("Error Compiling XPath Expression");
            }
        }

        public String getQueryStyle() {
            return XPathQueryResolver.STYLE_XPATH;
        }

        public String getQueryString() {
            return this.query;
        }

        public Collection getQueryContext() {
            return this.context;
        }

        public NamespaceMap getNamespaceMap() {
            return this.nsMap;
        }

        public Key[] getKeySet() {
            return this.keys;
        }

        public NodeSet execute() throws QueryException {
            try {
                Object object;
                Key[] keyArray = this.keys;
                if (this.keys == null && this.idxMgr != null) {
                    try {
                        object = this.evaluate(null, 0);
                        if (object instanceof NamedKeys) {
                            keyArray = ((NamedKeys)object).keys;
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                }
                if (keyArray == null) {
                    object = new TreeSet();
                    RecordSet recordSet = this.context.getFiler().getRecordSet();
                    while (recordSet.hasMoreRecords()) {
                        object.add(recordSet.getNextKey());
                    }
                    keyArray = object.toArray(EmptyKeys);
                }
                return new ResultSet(this.context, this.pr, keyArray, this.query);
            }
            catch (Exception exception) {
                throw new ProcessingException("Error executing XPath query");
            }
        }

        private Key[] andKeys(List list) {
            if (!list.isEmpty()) {
                if (list.size() > 1) {
                    Key[][] keyArray = (Key[][])list.toArray((T[])EmptyKeySet);
                    return QueryEngine.andKeySets(keyArray);
                }
                return (Key[])list.get(0);
            }
            return null;
        }

        private Object evaluate(String string, int n) throws Exception {
            int n2 = this.cmp.getOp(n);
            if (n2 == -1) {
                return null;
            }
            switch (n2) {
                case 28: {
                    return this.evalLocationPath(n2, string, n);
                }
                case 1: 
                case 26: 
                case 29: {
                    return this.evaluate(string, org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n));
                }
                case 2: 
                case 3: {
                    return this.evalSetComparison(n2, string, n);
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return this.evalValComparison(n2, string, n);
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return this.evalMathOperation(n2, string, n);
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return this.evalUnaryOperation(n2, string, n);
                }
                case 20: {
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    return this.evaluate(string, org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n));
                }
                case 24: {
                    break;
                }
                case 25: {
                    return this.evalFunction(n2, string, n);
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    return this.evalAxis(n2, string, n);
                }
                case 21: 
                case 27: 
                case 34: {
                    return this.evalLiteral(n2, string, n);
                }
                case 1031: 
                case 1033: {
                    return string;
                }
                case -3: 
                case 36: {
                    return XPathQueryResolver.WILDCARD;
                }
                case 35: 
                case 1030: 
                case 1032: 
                case 1034: {
                    break;
                }
                default: {
                    Debug.println((Object)("Unknown: " + n2));
                }
            }
            return null;
        }

        private Object evalLocationPath(int n, String string, int n2) throws Exception {
            int n3 = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2);
            ArrayList<Key[]> arrayList = new ArrayList<Key[]>();
            String string2 = null;
            boolean bl = false;
            while (this.cmp.getOp(n3) != -1) {
                Object object = this.evaluate(string, n3);
                if (object instanceof NamedKeys) {
                    Object object2;
                    NamedKeys namedKeys = (NamedKeys)object;
                    if (namedKeys.name != null) {
                        bl = namedKeys.attribute;
                        if (bl && string2 != null) {
                            object2 = new StringBuffer(32);
                            ((StringBuffer)object2).append(string2);
                            ((StringBuffer)object2).append('@');
                            ((StringBuffer)object2).append(namedKeys.name);
                            string2 = ((StringBuffer)object2).toString();
                        } else {
                            string2 = namedKeys.name;
                        }
                    }
                    if (namedKeys.keys != null) {
                        arrayList.add(namedKeys.keys);
                    } else if (string2 != null) {
                        object2 = new IndexPattern(this.symbols, string2, this.nsMap);
                        Indexer indexer = this.context.getIndexManager().getBestIndexer("Node:Name", (IndexPattern)object2);
                        if (indexer != null) {
                            IndexMatch[] indexMatchArray = indexer.queryMatches(new IndexQueryANY((IndexPattern)object2));
                            Key[] keyArray = QueryEngine.getUniqueKeys(indexMatchArray);
                            arrayList.add(keyArray);
                        }
                    }
                }
                n3 = this.cmp.getNextOpPos(n3);
            }
            return new NamedKeys(string2, bl, this.andKeys(arrayList));
        }

        private Object evalSetComparison(int n, String string, int n2) throws Exception {
            NamedKeys namedKeys;
            int n3 = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2);
            int n4 = this.cmp.getNextOpPos(n3);
            Object object = this.evaluate(string, n3);
            Object object2 = this.evaluate(string, n4);
            NamedKeys namedKeys2 = object instanceof NamedKeys ? (NamedKeys)object : null;
            NamedKeys namedKeys3 = namedKeys = object2 instanceof NamedKeys ? (NamedKeys)object2 : null;
            if (namedKeys2 != null && namedKeys != null && namedKeys2.keys != null && namedKeys.keys != null) {
                Key[][] keyArray = new Key[][]{namedKeys2.keys, namedKeys.keys};
                if (n == 2) {
                    return new NamedKeys(null, false, QueryEngine.orKeySets(keyArray));
                }
                return new NamedKeys(null, false, QueryEngine.andKeySets(keyArray));
            }
            if (n == 3) {
                if (namedKeys2 != null && namedKeys2.keys != null) {
                    return namedKeys2.keys;
                }
                if (namedKeys != null && namedKeys.keys != null) {
                    return namedKeys.keys;
                }
            }
            return null;
        }

        private Object evalValComparison(int n, String string, int n2) throws Exception {
            int n3 = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2);
            int n4 = this.cmp.getNextOpPos(n3);
            Object object = this.evaluate(string, n3);
            Object object2 = this.evaluate(string, n4);
            if (object instanceof XObject && object2 instanceof XObject) {
                switch (n) {
                    case 4: {
                        return new XBoolean(((XObject)object).notEquals((XObject)object2));
                    }
                    case 5: {
                        return new XBoolean(((XObject)object).equals((XObject)object2));
                    }
                    case 6: {
                        return new XBoolean(((XObject)object).lessThanOrEqual((XObject)object2));
                    }
                    case 7: {
                        return new XBoolean(((XObject)object).lessThan((XObject)object2));
                    }
                    case 8: {
                        return new XBoolean(((XObject)object).greaterThanOrEqual((XObject)object2));
                    }
                    case 9: {
                        return new XBoolean(((XObject)object).greaterThan((XObject)object2));
                    }
                }
                return null;
            }
            return this.queryComparison(n, string, object, object2);
        }

        private strictfp Object evalMathOperation(int n, String string, int n2) throws Exception {
            int n3 = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2);
            int n4 = this.cmp.getNextOpPos(n3);
            XObject xObject = (XObject)this.evaluate(string, n3);
            XObject xObject2 = (XObject)this.evaluate(string, n4);
            switch (n) {
                case 10: {
                    return new XNumber(xObject.num() + xObject2.num());
                }
                case 11: {
                    return new XNumber(xObject.num() - xObject2.num());
                }
                case 12: {
                    return new XNumber(xObject.num() * xObject2.num());
                }
                case 13: {
                    return new XNumber(xObject.num() / xObject2.num());
                }
                case 14: {
                    return new XNumber(xObject.num() % xObject2.num());
                }
                case 15: {
                    return new XNumber(xObject.num() / xObject2.num());
                }
            }
            return null;
        }

        private Object evalUnaryOperation(int n, String string, int n2) throws Exception {
            XObject xObject = (XObject)this.evaluate(string, org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2));
            switch (n) {
                case 16: {
                    return new XNumber(-xObject.num());
                }
                case 17: {
                    return new XString(xObject.str());
                }
                case 18: {
                    return new XBoolean(xObject.bool());
                }
                case 19: {
                    return new XNumber(xObject.num());
                }
            }
            return null;
        }

        private Object evalFunction(int n, String string, int n2) throws Exception {
            int n3 = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2);
            int n4 = this.cmp.getOp(n3);
            int n5 = n2 + this.cmp.getOpMap()[n2 + 1] - 1;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n6 = n3 + 1;
            while (n6 < n5) {
                arrayList.add(this.evaluate(string, n6));
                n6 = this.cmp.getNextOpPos(n6);
            }
            switch (n4) {
                case 14: {
                    return this.funcBoolean(string, arrayList);
                }
                case 17: {
                    return this.funcCeiling(string, arrayList);
                }
                case 27: {
                    return this.funcConcat(string, arrayList);
                }
                case 22: {
                    return this.funcContains(string, arrayList);
                }
                case 13: {
                    return XBoolean.S_FALSE;
                }
                case 16: {
                    return this.funcFloor(string, arrayList);
                }
                case 25: {
                    return this.funcNormalizeSpace(string, arrayList);
                }
                case 11: {
                    return this.funcNot(string, arrayList);
                }
                case 15: {
                    return this.funcNumber(string, arrayList);
                }
                case 18: {
                    return this.funcRound(string, arrayList);
                }
                case 21: {
                    return this.funcStartsWith(string, arrayList);
                }
                case 20: {
                    return this.funcString(string, arrayList);
                }
                case 30: {
                    return this.funcStringLength(string, arrayList);
                }
                case 29: {
                    return this.funcSubstring(string, arrayList);
                }
                case 24: {
                    return this.funcSubstringAfter(string, arrayList);
                }
                case 23: {
                    return this.funcSubstringBefore(string, arrayList);
                }
                case 26: {
                    return this.funcTranslate(string, arrayList);
                }
                case 12: {
                    return XBoolean.S_TRUE;
                }
            }
            return null;
        }

        private Object evalAxis(int n, String string, int n2) throws Exception {
            Object object;
            Object object2;
            String string2 = this.cmp.getStepNS(n2);
            string = (String)this.evaluate(string, org.apache.xpath.compiler.OpMap.getFirstChildPosOfStep((int)n2));
            if (string2 != null && this.nsMap != null) {
                Object object3 = null;
                object2 = this.nsMap.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (!this.nsMap.getNamespaceURI((String)object).equals(string2)) continue;
                    object3 = object;
                    break;
                }
                if (object3 != null) {
                    object = new StringBuffer(32);
                    ((StringBuffer)object).append((String)object3);
                    ((StringBuffer)object).append(':');
                    ((StringBuffer)object).append(string);
                    string = ((StringBuffer)object).toString();
                }
            }
            int n3 = this.cmp.getFirstPredicateOpPos(n2);
            object2 = new ArrayList();
            while (n3 < n2 + this.cmp.getOp(n2 + 1)) {
                object = this.evaluate(string, n3);
                if (object instanceof NamedKeys) {
                    NamedKeys namedKeys = (NamedKeys)object;
                    if (namedKeys.keys != null) {
                        object2.add(namedKeys.keys);
                    }
                }
                n3 = this.cmp.getNextOpPos(n3);
            }
            return new NamedKeys(string, n == 39, this.andKeys((List)object2));
        }

        private Object evalLiteral(int n, String string, int n2) throws Exception {
            int n3 = this.cmp.getOp(org.apache.xpath.compiler.OpMap.getFirstChildPos((int)n2));
            switch (n3) {
                case -2: {
                    return string;
                }
                case -3: {
                    return XPathQueryResolver.WILDCARD;
                }
            }
            return this.cmp.getToken(n3);
        }

        private Object funcBoolean(String string, List list) throws Exception {
            if (list.size() == 1) {
                Object e = list.get(0);
                if (e instanceof XObject) {
                    if (((XObject)e).bool()) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
                return e;
            }
            return null;
        }

        private Object funcCeiling(String string, List list) throws Exception {
            Object e;
            if (list.size() == 1 && (e = list.get(0)) instanceof XObject) {
                return new XNumber(Math.ceil(((XObject)e).num()));
            }
            return null;
        }

        private Object funcConcat(String string, List list) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < list.size()) {
                Object e = list.get(n);
                if (e instanceof XObject) {
                    stringBuffer.append(((XObject)e).str());
                }
                ++n;
            }
            return new XString(stringBuffer.toString());
        }

        private Object funcContains(String string, List list) {
            if (list.size() == 2) {
                Object e = list.get(0);
                Object e2 = list.get(1);
                if (e instanceof XObject && e2 instanceof XObject) {
                    if (((XObject)e).str().indexOf(((XObject)e2).str()) != -1) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
            }
            return null;
        }

        private Object funcFloor(String string, List list) throws Exception {
            Object e;
            if (list.size() == 1 && (e = list.get(0)) instanceof XObject) {
                return new XNumber(Math.floor(((XObject)e).num()));
            }
            return null;
        }

        private Object funcNormalizeSpace(String string, List list) {
            if (list.size() == 1) {
                Object e = list.get(0);
                if (e instanceof XObject) {
                    return new XString(QueryEngine.normalizeString(((XObject)e).str()));
                }
                return e;
            }
            return null;
        }

        private Object funcNot(String string, List list) throws Exception {
            Object e;
            if (list.size() == 1 && (e = list.get(0)) instanceof XObject) {
                if (((XObject)e).bool()) {
                    return XBoolean.S_FALSE;
                }
                return XBoolean.S_TRUE;
            }
            return null;
        }

        private Object funcNumber(String string, List list) throws Exception {
            if (list.size() == 1) {
                Object e = list.get(0);
                if (e instanceof XObject) {
                    return new XNumber(((XObject)e).num());
                }
                return e;
            }
            return null;
        }

        private Object funcRound(String string, List list) throws Exception {
            Object e;
            if (list.size() == 1 && (e = list.get(0)) instanceof XObject) {
                return new XNumber((double)Math.round(((XObject)e).num()));
            }
            return null;
        }

        private Object funcStartsWith(String string, List list) {
            if (list.size() == 2) {
                Object e = list.get(0);
                Object e2 = list.get(1);
                if (e instanceof XObject && e2 instanceof XObject) {
                    if (((XObject)e).str().startsWith(((XObject)e2).str())) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
                if (e instanceof NamedKeys && e2 instanceof XObject) {
                    NamedKeys namedKeys = (NamedKeys)e;
                    String string2 = namedKeys.attribute && namedKeys.name.indexOf(64) == -1 ? string + "@" + namedKeys.name : namedKeys.name;
                    IndexPattern indexPattern = new IndexPattern(this.symbols, string2, this.nsMap);
                    XObject xObject = (XObject)e2;
                    Value value = new Value(xObject.str());
                    IndexQuerySW indexQuerySW = new IndexQuerySW(indexPattern, value);
                    return this.queryIndexes(namedKeys, indexQuerySW, string2, xObject.getType());
                }
            }
            return null;
        }

        private Object funcString(String string, List list) {
            if (list.size() == 1) {
                Object e = list.get(0);
                if (e instanceof XObject) {
                    return new XString(((XObject)e).str());
                }
                return e;
            }
            return null;
        }

        private Object funcStringLength(String string, List list) {
            Object e;
            if (list.size() == 1 && (e = list.get(0)) instanceof XObject) {
                return new XNumber((double)((XObject)e).str().length());
            }
            return null;
        }

        private Object funcSubstring(String string, List list) throws Exception {
            if (list.size() == 2 || list.size() == 3) {
                Object e = list.get(0);
                Object e2 = list.get(1);
                Object e3 = list.get(2);
                if (e instanceof XObject && e2 instanceof XObject && (e3 == null || e3 instanceof XObject)) {
                    int n = (int)((XObject)e2).num() - 1;
                    if (e3 != null) {
                        int n2 = (int)((XObject)e3).num();
                        return new XString(((XObject)e).str().substring(n, n + n2));
                    }
                    return new XString(((XObject)e).str().substring(n));
                }
            }
            return null;
        }

        private Object funcSubstringAfter(String string, List list) {
            if (list.size() == 2) {
                Object e = list.get(0);
                Object e2 = list.get(1);
                if (e instanceof XObject && e2 instanceof XObject) {
                    String string2;
                    String string3 = ((XObject)e).str();
                    int n = string3.indexOf(string2 = ((XObject)e2).str());
                    if (n == -1) {
                        return new XString("");
                    }
                    return new XString(string3.substring(n + string2.length()));
                }
            }
            return null;
        }

        private Object funcSubstringBefore(String string, List list) {
            if (list.size() == 2) {
                Object e = list.get(0);
                Object e2 = list.get(1);
                if (e instanceof XObject && e2 instanceof XObject) {
                    String string2;
                    String string3 = ((XObject)e).str();
                    int n = string3.indexOf(string2 = ((XObject)e2).str());
                    if (n == -1) {
                        return new XString("");
                    }
                    return new XString(string3.substring(0, n));
                }
            }
            return null;
        }

        private Object funcTranslate(String string, List list) {
            if (list.size() == 3) {
                Object e = list.get(0);
                Object e2 = list.get(1);
                Object e3 = list.get(2);
                if (e instanceof XObject && e2 instanceof XObject && e3 instanceof XObject) {
                    char c = ((XObject)e2).str().charAt(0);
                    char c2 = ((XObject)e3).str().charAt(0);
                    return new XString(((XObject)e).str().replace(c, c2));
                }
            }
            return null;
        }

        private Object queryIndexes(NamedKeys namedKeys, IndexQuery indexQuery, String string, int n) {
            try {
                IndexPattern indexPattern = indexQuery.getPattern();
                Indexer indexer = this.context.getIndexManager().getBestIndexer("Node:Value", indexPattern);
                if (indexer != null) {
                    return new NamedKeys(namedKeys.name, namedKeys.attribute, QueryEngine.getUniqueKeys(indexer.queryMatches(indexQuery)));
                }
                if (XPathQueryResolver.this.autoIndex) {
                    Element element = new DocumentImpl().createElement("index");
                    element.setAttribute("class", "org.dbxml.core.indexer.ValueIndexer");
                    element.setAttribute("name", "xp_" + string);
                    element.setAttribute("pattern", string);
                    String string2 = null;
                    switch (n) {
                        case 1: {
                            string2 = "boolean";
                            break;
                        }
                        case 2: {
                            string2 = "double";
                            break;
                        }
                        case 3: {
                            string2 = string.indexOf(64) != -1 ? "string" : "trimmed";
                        }
                    }
                    if (string2 != null) {
                        element.setAttribute("type", string2);
                    }
                    this.idxMgr.create(new Configuration(element));
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
            return null;
        }

        private Object queryComparison(int n, String string, Object object, Object object2) {
            IndexQuery indexQuery;
            Object object3;
            if (!(object instanceof NamedKeys && object2 instanceof XObject || object instanceof XObject && object2 instanceof NamedKeys)) {
                return null;
            }
            n = OpMap[n - 4];
            if (object instanceof XObject) {
                if (n == 2 || n == 3 || n == -3 || n == -2) {
                    n = -n;
                }
                object3 = object;
                object = object2;
                object2 = object3;
            }
            object3 = (NamedKeys)object;
            XObject xObject = (XObject)object2;
            String string2 = ((NamedKeys)object3).attribute && ((NamedKeys)object3).name.indexOf(64) == -1 ? string + "@" + ((NamedKeys)object3).name : ((NamedKeys)object3).name;
            IndexPattern indexPattern = new IndexPattern(this.symbols, string2, this.nsMap);
            String string3 = xObject.str();
            switch (n) {
                case -1: {
                    indexQuery = new IndexQueryNEQ(indexPattern, string3);
                    break;
                }
                case 1: {
                    indexQuery = new IndexQueryEQ(indexPattern, string3);
                    break;
                }
                case -2: {
                    indexQuery = new IndexQueryLEQ(indexPattern, string3);
                    break;
                }
                case 3: {
                    indexQuery = new IndexQueryLT(indexPattern, string3);
                    break;
                }
                case -3: {
                    indexQuery = new IndexQueryGEQ(indexPattern, string3);
                    break;
                }
                case 2: {
                    indexQuery = new IndexQueryGT(indexPattern, string3);
                    break;
                }
                default: {
                    indexQuery = null;
                }
            }
            return this.queryIndexes((NamedKeys)object3, indexQuery, string2, xObject.getType());
        }
    }
}

