/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.request;

import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.Container;
import org.dbxml.core.DBException;
import org.dbxml.core.Database;
import org.dbxml.core.objects.MapArgs;
import org.dbxml.core.objects.Reflectable;
import org.dbxml.core.objects.Reflector;
import org.dbxml.core.objects.XMLObject;
import org.dbxml.core.objects.XMLObjectException;
import org.dbxml.server.ObjectPool;
import org.dbxml.server.Poolable;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.TextWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class URIMapper
extends URLConnection
implements Poolable {
    public static final int UNKNOWN = -1;
    public static final int APPLICATION = 1;
    public static final int COLLECTION = 2;
    public static final int DOCUMENT = 3;
    public static final int XMLOBJECT = 4;
    private static final String[] EmptyStrings = new String[0];
    private ObjectPool pool = null;
    private String uri = null;
    private int type = 0;
    private byte[] buf = null;
    private int pos = 0;
    private char lastChar = '\u0000';
    private Database db = null;
    private Collection collection = null;
    private Document document = null;
    private XMLObject xmlObject = null;
    private String method = null;
    private Container container = null;
    private Properties params = null;
    private String[] args = null;
    private String urlresult = null;
    private boolean inputstreamset = false;

    public URIMapper(URL uRL) {
        super(uRL);
        try {
            this.setURI(uRL.toString());
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public URIMapper(String string) throws dbXMLException {
        super(null);
        this.setURI(string);
    }

    public URIMapper() {
        super(null);
    }

    public Object invokeRequest() throws XMLObjectException {
        XMLObject xMLObject = this.getXMLObject();
        String string = this.getMethod();
        Reflector reflector = xMLObject.getReflector();
        Properties properties = this.getProperties();
        Object object = properties != null ? reflector.invoke((Reflectable)xMLObject, string, new MapArgs(properties)) : reflector.invoke((Reflectable)xMLObject, string, this.getArguments());
        return object;
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() {
        String string = null;
        Object object = null;
        if (!this.inputstreamset) {
            try {
                switch (this.type) {
                    case 3: {
                        StringWriter stringWriter = new StringWriter();
                        object = this.getDocument();
                        TextWriter.write((Node)object, stringWriter);
                        string = ((Object)stringWriter).toString();
                        break;
                    }
                    case 4: {
                        object = this.invokeRequest();
                        if (object instanceof Node) {
                            StringWriter stringWriter = new StringWriter();
                            TextWriter.write((Node)object, stringWriter);
                            string = ((Object)stringWriter).toString();
                            break;
                        }
                        if (object != null) {
                            string = object.toString();
                        }
                        break;
                    }
                    default: {
                        throw new Exception("Content type unsupported");
                    }
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        } else {
            string = this.urlresult;
        }
        this.urlresult = string;
        this.inputstreamset = true;
        if (string == null) {
            return new StringBufferInputStream("");
        }
        return new StringBufferInputStream(string);
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentType() {
        return new String("text/xml");
    }

    public int getContentLength() {
        if (!this.inputstreamset) {
            this.getInputStream();
        }
        return this.urlresult.length();
    }

    public long getLastModified() {
        return 0L;
    }

    public void setPool(ObjectPool objectPool) {
        this.pool = objectPool;
    }

    public void reclaim() {
        if (this.xmlObject != null && this.xmlObject instanceof Poolable) {
            ((Poolable)this.xmlObject).reclaim();
        }
        this.reset();
        if (this.pool != null) {
            this.pool.putObject((Poolable)this);
        }
    }

    private void reset() {
        this.type = -1;
        this.lastChar = '\u0000';
        this.method = "";
        this.db = null;
        this.collection = null;
        this.document = null;
        this.xmlObject = null;
        this.params = null;
        this.args = null;
        this.container = null;
        this.urlresult = null;
        this.inputstreamset = false;
    }

    public void setURI(String string) throws dbXMLException {
        this.uri = string;
        this.reset();
        this.parse();
    }

    private String parseName(String string) {
        int n = this.pos;
        while (this.pos < this.buf.length) {
            this.lastChar = (char)this.buf[this.pos++];
            if (string.indexOf(this.lastChar) != -1) break;
        }
        if (this.pos == this.buf.length && string.indexOf(this.lastChar) == -1) {
            ++this.pos;
        }
        return this.pos > n ? new String(this.buf, n, this.pos - n - 1) : "";
    }

    private void parseParams() {
        if (this.lastChar == '?') {
            String string;
            this.params = new Properties();
            while ((string = this.parseName("=")).length() != 0) {
                String string2 = this.parseName("?&;");
                String string3 = this.params.getProperty(string);
                if (string3 != null) {
                    StringBuffer stringBuffer = new StringBuffer(32);
                    stringBuffer.append(string3);
                    stringBuffer.append('\u0001');
                    stringBuffer.append(string2);
                    string2 = stringBuffer.toString();
                }
                this.params.setProperty(string, string2);
            }
        } else if (this.lastChar == '(') {
            String string = new String(this.buf, this.pos, this.buf.length - this.pos);
            StringReader stringReader = new StringReader(string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.wordChars(48, 122);
            streamTokenizer.wordChars(13, 13);
            streamTokenizer.ordinaryChars(33, 46);
            streamTokenizer.ordinaryChars(58, 64);
            streamTokenizer.ordinaryChars(91, 96);
            streamTokenizer.ordinaryChars(123, 127);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            streamTokenizer.quoteChar(124);
            streamTokenizer.commentChar(47);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            try {
                while (!bl && streamTokenizer.nextToken() != -1) {
                    switch (streamTokenizer.ttype) {
                        case -3: {
                            arrayList.add(streamTokenizer.sval);
                            break;
                        }
                        case 34: {
                            arrayList.add(streamTokenizer.sval);
                            break;
                        }
                        case 39: 
                        case 124: {
                            arrayList.add(streamTokenizer.sval);
                            break;
                        }
                        case 91: {
                            boolean bl2 = false;
                            StringBuffer stringBuffer = new StringBuffer();
                            while (!bl2 && streamTokenizer.nextToken() != -1) {
                                switch (streamTokenizer.ttype) {
                                    case -3: {
                                        if (stringBuffer.length() > 0) {
                                            stringBuffer.append('\u0001');
                                        }
                                        stringBuffer.append(streamTokenizer.sval);
                                        break;
                                    }
                                    case 93: {
                                        bl2 = true;
                                    }
                                }
                            }
                            arrayList.add(stringBuffer.toString());
                            break;
                        }
                        case 41: {
                            bl = true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
                return;
            }
            this.args = arrayList.toArray(EmptyStrings);
        } else {
            this.params = new Properties();
        }
    }

    private void parseXMLObject() {
        try {
            if (this.lastChar == '/') {
                this.method = this.parseName("/(?");
            }
            if (this.method.length() == 0) {
                this.method = "execute";
            }
            this.type = 4;
            this.parseParams();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    private void parse() throws dbXMLException {
        String string;
        this.buf = this.uri.getBytes();
        this.pos = 0;
        if (this.buf.length == 0) {
            throw new DBException(800);
        }
        if ((char)this.buf[0] != '/') {
            this.parseName(":");
            this.parseName("/");
            this.parseName("/");
            this.parseName("/:");
            if (this.lastChar == ':') {
                this.parseName("/");
            }
        } else {
            this.pos = 1;
        }
        if ((string = this.parseName("/")) == null) {
            return;
        }
        this.db = Database.getDatabase(string);
        if (this.db == null) {
            return;
        }
        this.type = 1;
        string = this.parseName("/(?");
        int n = this.getParsedObjectType(this.db, string);
        if (n != -1) {
            this.type = this.walkURI(this.db, string, n);
        }
        if (this.lastChar == '?') {
            this.parseParams();
            return;
        }
    }

    protected int walkURI(Collection collection, String string, int n) throws dbXMLException {
        switch (n) {
            case 3: {
                this.container = collection.getContainer(string);
                this.document = this.container.getDocument();
                return 3;
            }
            case 4: {
                this.xmlObject = collection.getXMLObject(string);
                if (this.xmlObject == null) break;
                this.parseXMLObject();
                return 4;
            }
            case 2: {
                Collection collection2 = collection.getCollection(string);
                if (collection2 == null) break;
                this.collection = collection2;
                String string2 = this.parseName("/(?");
                if (!string2.equals("")) {
                    return this.walkURI(collection2, string2, this.getParsedObjectType(collection2, string2));
                }
                return 2;
            }
        }
        return -1;
    }

    protected int getParsedObjectType(Collection collection, String string) throws dbXMLException {
        if (collection.getCollection(string) != null) {
            return 2;
        }
        if (collection.getXMLObject(string) != null) {
            return 4;
        }
        if (collection.getFiler() != null && collection.getContainer(string) != null) {
            return 3;
        }
        return -1;
    }

    public int getObjectType() {
        return this.type;
    }

    public Database getDatabase() {
        return this.db;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Document getDocument() {
        return this.document;
    }

    public Container getContainer() {
        return this.container;
    }

    public XMLObject getXMLObject() {
        return this.xmlObject;
    }

    public String getMethod() {
        return this.method;
    }

    public Properties getProperties() {
        return this.params;
    }

    public String[] getArguments() {
        return this.args;
    }
}

