/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.security;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.dbxml.Debug;
import org.dbxml.core.Database;
import org.dbxml.core.security.AccessDeniedException;
import org.dbxml.core.security.Credentials;
import org.dbxml.core.security.DBSecurityManager;
import org.dbxml.core.security.InvalidCredentialsException;
import org.dbxml.core.security.InvalidPasswordException;
import org.dbxml.core.security.PasswordCredentials;
import org.dbxml.core.security.ResourcePermissions;
import org.dbxml.core.security.UnknownUserException;
import org.dbxml.server.Configuration;
import org.dbxml.server.ConfigurationCallback;
import org.dbxml.server.ReadOnlyException;
import org.dbxml.xml.dom.DOMParser;
import org.w3c.dom.Document;

public class LocalSecurityManager
implements DBSecurityManager {
    private static final String ACL_COLLECTION = "system/SysAccess";
    private static final String ACL_FILE = "config/acl.xml";
    private static final String PERMISSIONS = "permissions";
    private static final String COLLECTIONS = "collections";
    private static final String COLLECTION = "collection";
    private static final String DOCUMENTS = "documents";
    private static final String XMLOBJECTS = "xmlobjects";
    private static final String XMLOBJECT = "xmlobject";
    private static final String RESOURCES = "resources";
    private static final String RESOURCE = "resource";
    private static final String NAME = "name";
    private static final String CORE = "core";
    private static final String ADMIN = "admin";
    private static final String ALL_ACCESS_GROUP = "dbxml-sys-all";
    protected Configuration config = null;
    protected Database db = null;
    protected HashMap permissions = null;
    private static ThreadLocal credentials = new ThreadLocal();
    private boolean startup = true;
    private boolean disabled = false;

    public LocalSecurityManager(Database database, boolean bl) {
        this.db = database;
        this.disabled = bl;
        this.permissions = new HashMap();
    }

    public String getName() {
        return "LocalSecurityManager";
    }

    public void checkAccess(String string, int n, Credentials credentials) throws AccessDeniedException, InvalidCredentialsException {
        if (this.startup || this.disabled) {
            return;
        }
        if (credentials == null) {
            throw new InvalidCredentialsException();
        }
        ResourcePermissions resourcePermissions = (ResourcePermissions)this.permissions.get(string);
        ArrayList arrayList = credentials.getGroups();
        if (arrayList.contains(ADMIN)) {
            return;
        }
        if (resourcePermissions != null) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                String string2 = (String)arrayList.get(n2);
                if (resourcePermissions.checkPermission(100, n, ALL_ACCESS_GROUP)) {
                    return;
                }
                if (resourcePermissions.checkPermission(101, n, string2)) {
                    throw new AccessDeniedException();
                }
                if (resourcePermissions.checkPermission(100, n, string2)) {
                    return;
                }
                ++n2;
            }
        }
        throw new AccessDeniedException();
    }

    public void checkAccess(String string, int n) throws AccessDeniedException, InvalidCredentialsException {
        this.checkAccess(string, n, (Credentials)credentials.get());
    }

    public Credentials authenticate(String string, String string2) throws InvalidPasswordException, UnknownUserException, InvalidCredentialsException {
        PasswordCredentials passwordCredentials = new PasswordCredentials(string, string2, this.db);
        credentials.set(passwordCredentials);
        return passwordCredentials;
    }

    public void logout() {
        credentials.set(null);
    }

    public void setActive() {
        this.startup = false;
    }

    public void readConfig() {
        String string = "/";
        try {
            FileInputStream fileInputStream;
            Document document = null;
            String string2 = ACL_FILE;
            try {
                fileInputStream = new FileInputStream(string2);
                document = DOMParser.toDocument(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                Debug.println((Object)("\u0007FATAL ERROR: Reading security configuration file '" + string2 + "'"));
                Debug.printStackTrace((Throwable)exception);
                System.exit(1);
            }
            if (document != null) {
                fileInputStream = new Configuration(document.getDocumentElement(), false);
                Configuration configuration = fileInputStream.getChild(CORE);
                final String string3 = string + configuration.getAttribute(NAME) + "/";
                this.handleConfig(string3, configuration.getChild(PERMISSIONS, true));
                Configuration configuration2 = configuration.getChild(COLLECTIONS);
                if (configuration2 != null) {
                    configuration2.processChildren(COLLECTION, new ConfigurationCallback(){

                        public void process(Configuration configuration) {
                            try {
                                Debug.println((Object)configuration.getName());
                                String string = string3 + configuration.getAttribute(LocalSecurityManager.NAME) + "/";
                                LocalSecurityManager.this.handleCollection(string3, configuration);
                            }
                            catch (ReadOnlyException readOnlyException) {
                                Debug.printStackTrace((Throwable)readOnlyException);
                            }
                        }
                    });
                }
            } else {
                Debug.println((Object)"Access Control List could not be loaded");
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    protected void handleCollection(String string, Configuration configuration) throws ReadOnlyException {
        if (configuration != null) {
            Configuration configuration2;
            final String string2 = string + configuration.getAttribute(NAME) + "/";
            Configuration configuration3 = configuration.getChild(PERMISSIONS, true);
            if (configuration3 != null) {
                this.handleConfig(string2, configuration3);
            }
            this.processChildren(string2, XMLOBJECTS, XMLOBJECT, configuration);
            configuration3 = configuration.getChild(DOCUMENTS, true);
            if (configuration3 != null) {
                this.processChildren(string2, RESOURCES, RESOURCE, configuration3);
                this.processChildren(string2, XMLOBJECTS, XMLOBJECT, configuration3);
            }
            if ((configuration2 = configuration.getChild(COLLECTIONS)) != null) {
                configuration2.processChildren(COLLECTION, new ConfigurationCallback(){

                    public void process(Configuration configuration) {
                        try {
                            String string = string2 + configuration.getAttribute(LocalSecurityManager.NAME) + "/";
                            LocalSecurityManager.this.handleCollection(string2, configuration);
                        }
                        catch (ReadOnlyException readOnlyException) {
                            Debug.printStackTrace((Throwable)readOnlyException);
                        }
                    }
                });
            }
        }
    }

    protected void processChildren(final String string, String string2, String string3, Configuration configuration) throws ReadOnlyException {
        Configuration configuration2 = configuration.getChild(string2, true);
        if (configuration2 != null) {
            configuration2.processChildren(string3, new ConfigurationCallback(){

                public void process(Configuration configuration) {
                    try {
                        String string2 = string + configuration.getAttribute(LocalSecurityManager.NAME) + "/";
                        LocalSecurityManager.this.handleConfig(string2, configuration.getChild(LocalSecurityManager.PERMISSIONS, true));
                    }
                    catch (ReadOnlyException readOnlyException) {
                        Debug.printStackTrace((Throwable)readOnlyException);
                    }
                }
            });
        }
    }

    protected void handleConfig(String string, Configuration configuration) {
        if (configuration != null) {
            try {
                ResourcePermissions resourcePermissions = new ResourcePermissions(string);
                resourcePermissions.setConfig(configuration);
                this.permissions.put(string, resourcePermissions);
            }
            catch (NullPointerException nullPointerException) {
                Debug.println((Object)"Name attribute is required for all ACL objects");
            }
        }
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfig() {
        return this.config;
    }
}

