/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.security;

import java.util.ArrayList;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.Database;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.security.AccessDeniedException;
import org.dbxml.core.security.Credentials;
import org.dbxml.core.security.InvalidCredentialsException;
import org.dbxml.core.security.InvalidPasswordException;
import org.dbxml.core.security.UnknownUserException;
import org.dbxml.server.dbXMLException;
import org.dbxml.server.util.MD5;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PasswordCredentials
implements Credentials {
    private static final String COLLECTION = "system/SysGroups";
    protected boolean isValid = false;
    protected String username = null;
    protected String password = null;
    protected ArrayList groups = null;
    protected Database db = null;

    public PasswordCredentials(String string, String string2, Database database) throws InvalidPasswordException, UnknownUserException {
        this.username = string;
        this.password = string2;
        this.db = database;
        this.groups = new ArrayList();
        try {
            Collection collection = database.getCollection("system/SysUsers");
            Document document = null;
            try {
                Debug.println((Object)("USER: " + string));
                document = collection.getDocument(string);
                if (document == null) {
                    throw new UnknownUserException();
                }
            }
            catch (DBException dBException) {
                Debug.printStackTrace((Throwable)((Object)dBException));
            }
            new MD5();
            String string3 = MD5.md((String)string2).toString();
            if (!document.getDocumentElement().getAttribute("password").equals(string3)) {
                throw new InvalidPasswordException();
            }
            Collection collection2 = database.getCollection(COLLECTION);
            NodeSet nodeSet = collection2.queryCollection("XPath", "/group/members/member/@name='" + string + "'", null);
            if (nodeSet != null) {
                while (nodeSet.hasMoreNodes()) {
                    Node node = nodeSet.getNextNode();
                    String string4 = ((Element)node).getAttribute("name");
                    this.groups.add(string4);
                }
            }
        }
        catch (dbXMLException dbXMLException2) {
            Debug.printStackTrace((Throwable)dbXMLException2);
            throw new UnknownUserException();
        }
        this.isValid = true;
    }

    public void verify() throws InvalidCredentialsException {
        if (this.username == null || this.password == null || !this.isValid) {
            throw new InvalidCredentialsException();
        }
    }

    public boolean checkGroup(String string) throws AccessDeniedException, InvalidCredentialsException {
        return this.groups.contains(string);
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

