/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.security;

import java.util.ArrayList;
import org.dbxml.core.security.Permission;
import org.dbxml.server.Configurable;
import org.dbxml.server.Configuration;
import org.dbxml.server.ConfigurationCallback;

public class ResourcePermissions
implements Configurable {
    private static final String ALLOW = "allow";
    private static final String DENY = "deny";
    private static final String ALL = "all";
    protected ArrayList allowRead = null;
    protected ArrayList allowWrite = null;
    protected ArrayList allowExecute = null;
    protected ArrayList allowDelete = null;
    protected ArrayList allowModify = null;
    protected ArrayList allowAdmin = null;
    protected ArrayList denyRead = null;
    protected ArrayList denyWrite = null;
    protected ArrayList denyExecute = null;
    protected ArrayList denyDelete = null;
    protected ArrayList denyModify = null;
    protected ArrayList denyAdmin = null;
    protected String resource = "";
    protected Configuration config = null;

    public ResourcePermissions(String string) {
        this.resource = string;
    }

    public void addPermissionAllow(int n, String string) {
        switch (n) {
            case 1: {
                this.allowRead = this.addPermission(this.allowRead, string);
                break;
            }
            case 2: {
                this.allowWrite = this.addPermission(this.allowWrite, string);
                break;
            }
            case 3: {
                this.allowDelete = this.addPermission(this.allowDelete, string);
                break;
            }
            case 4: {
                this.allowModify = this.addPermission(this.allowModify, string);
                break;
            }
            case 5: {
                this.allowExecute = this.addPermission(this.allowExecute, string);
                break;
            }
            case 6: {
                this.allowAdmin = this.addPermission(this.allowAdmin, string);
            }
        }
    }

    public void addPermissionDeny(int n, String string) {
        switch (n) {
            case 1: {
                this.denyRead = this.addPermission(this.denyRead, string);
                break;
            }
            case 2: {
                this.denyWrite = this.addPermission(this.denyWrite, string);
                break;
            }
            case 3: {
                this.denyDelete = this.addPermission(this.denyDelete, string);
                break;
            }
            case 4: {
                this.denyModify = this.addPermission(this.denyModify, string);
                break;
            }
            case 5: {
                this.denyExecute = this.addPermission(this.denyExecute, string);
                break;
            }
            case 6: {
                this.denyAdmin = this.addPermission(this.denyAdmin, string);
            }
        }
    }

    protected ArrayList addPermission(ArrayList arrayList, String string) {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(string);
        return arrayList;
    }

    public boolean checkPermission(int n, int n2, String string) {
        if (n == 100) {
            switch (n2) {
                case 1: {
                    return this.checkPermission(this.allowRead, string);
                }
                case 2: {
                    return this.checkPermission(this.allowWrite, string);
                }
                case 3: {
                    return this.checkPermission(this.allowDelete, string);
                }
                case 4: {
                    return this.checkPermission(this.allowModify, string);
                }
                case 5: {
                    return this.checkPermission(this.allowExecute, string);
                }
                case 6: {
                    return this.checkPermission(this.allowAdmin, string);
                }
            }
        } else if (n == 101) {
            switch (n2) {
                case 1: {
                    return this.checkPermission(this.denyRead, string);
                }
                case 2: {
                    return this.checkPermission(this.denyWrite, string);
                }
                case 3: {
                    return this.checkPermission(this.denyDelete, string);
                }
                case 4: {
                    return this.checkPermission(this.denyModify, string);
                }
                case 5: {
                    return this.checkPermission(this.denyExecute, string);
                }
                case 6: {
                    return this.checkPermission(this.denyAdmin, string);
                }
            }
        }
        return false;
    }

    protected boolean checkPermission(ArrayList arrayList, String string) {
        return arrayList != null && arrayList.indexOf(string) != -1;
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
        configuration.processChildren(ALLOW, new ConfigurationCallback(){

            public void process(Configuration configuration) {
                String string = configuration.getAttribute("type", "");
                String string2 = configuration.getAttribute("group", "");
                if (string.equalsIgnoreCase(ResourcePermissions.ALL)) {
                    ResourcePermissions.this.addPermissionAllow(1, string2);
                    ResourcePermissions.this.addPermissionAllow(2, string2);
                    ResourcePermissions.this.addPermissionAllow(3, string2);
                    ResourcePermissions.this.addPermissionAllow(5, string2);
                    ResourcePermissions.this.addPermissionAllow(4, string2);
                } else {
                    ResourcePermissions.this.addPermissionAllow(Permission.mapType(string), string2);
                }
            }
        });
        configuration.processChildren(DENY, new ConfigurationCallback(){

            public void process(Configuration configuration) {
                String string = configuration.getAttribute("type", "");
                String string2 = configuration.getAttribute("group", "");
                if (string.equalsIgnoreCase(ResourcePermissions.ALL)) {
                    ResourcePermissions.this.addPermissionDeny(1, string2);
                    ResourcePermissions.this.addPermissionDeny(2, string2);
                    ResourcePermissions.this.addPermissionDeny(3, string2);
                    ResourcePermissions.this.addPermissionDeny(5, string2);
                    ResourcePermissions.this.addPermissionDeny(4, string2);
                } else {
                    ResourcePermissions.this.addPermissionDeny(Permission.mapType(string), string2);
                }
            }
        });
    }

    public Configuration getConfig() {
        return this.config;
    }
}

