/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.server.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import org.dbxml.Debug;
import org.dbxml.core.Database;
import org.dbxml.core.corba.DatabaseServant;
import org.dbxml.server.Configuration;
import org.dbxml.server.Kernel;
import org.dbxml.server.KernelAccess;
import org.dbxml.server.ManagerService;
import org.dbxml.server.Service;
import org.dbxml.server.ServiceManager;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class APIService
extends SimpleConfigurable
implements Service,
KernelAccess,
Runnable,
ManagerService {
    private static final String NAMING = "naming";
    private static final String NAME = "name";
    private static final String URI = "uri";
    private static final String PROPERTY = "property";
    private static final String ROOT_CONTEXT = "dbxml";
    private static final String CORBA = "corba";
    private static final String CLASS = "class";
    private static final String SINGLETON = "singleton";
    private ORB orb;
    protected Properties props = new Properties();
    protected Kernel kernel;
    protected ServiceManager serviceManager;
    protected int status;
    protected String statusMessage;
    protected String namingURI;
    protected String namingProp;
    protected boolean useNaming = false;

    public void setConfig(Configuration configuration) throws dbXMLException {
        try {
            Configuration configuration2 = configuration.getChild(NAMING);
            if (configuration2 != null) {
                this.namingURI = configuration2.getAttribute(URI);
                this.namingProp = configuration2.getAttribute(PROPERTY);
            }
            if (this.namingURI != null) {
                this.useNaming = true;
            }
        }
        catch (Exception exception) {
            Debug.println((java.lang.Object)this, (java.lang.Object)exception);
        }
    }

    public synchronized int initialize() {
        return 0;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void run() {
        try {
            java.lang.Object object;
            this.orb.run();
            java.lang.Object object2 = object = new java.lang.Object();
            synchronized (object2) {
                object.wait();
            }
        }
        catch (Exception exception) {
            Debug.println((java.lang.Object)this, (java.lang.Object)exception);
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public int status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public int start() {
        try {
            java.lang.Object object;
            String[] stringArray;
            Properties properties = new Properties();
            if (this.useNaming) {
                ((Hashtable)properties).put(this.namingProp, this.namingURI);
            }
            Configuration configuration = this.kernel.getCommonConfig().getChild(CORBA);
            ((Hashtable)properties).put("org.omg.CORBA.ORBClass", configuration.getAttribute(CLASS));
            ((Hashtable)properties).put("org.omg.CORBA.ORBSingletonClass", configuration.getAttribute(SINGLETON));
            this.orb = ORB.init((String[])new String[0], (Properties)properties);
            POA pOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            NamingContextExt namingContextExt = null;
            NameComponent nameComponent = null;
            if (this.useNaming) {
                namingContextExt = NamingContextExtHelper.narrow((Object)this.orb.resolve_initial_references("NameService"));
                nameComponent = new NameComponent(ROOT_CONTEXT, "");
                stringArray = new NameComponent[]{nameComponent};
                NamingContext namingContext = namingContextExt.bind_new_context((NameComponent[])stringArray);
            }
            stringArray = Database.listDatabases();
            int n = 0;
            File file = null;
            FileOutputStream fileOutputStream = null;
            PrintStream printStream = null;
            try {
                file = new File(new File(System.getProperty("dbxml.home")), "/config/instances.cfg");
                fileOutputStream = new FileOutputStream(file);
                printStream = new PrintStream(fileOutputStream);
            }
            catch (Exception exception) {
                Debug.println((java.lang.Object)("Unable to write '" + file.getAbsolutePath() + "'"));
                fileOutputStream = null;
                printStream = null;
            }
            while (n < stringArray.length) {
                PrintWriter printWriter;
                object = stringArray[n];
                Database database = Database.getDatabase((String)object);
                DatabaseServant databaseServant = new DatabaseServant(database, this.kernel);
                pOA.activate_object((Servant)databaseServant);
                pOA.the_POAManager().activate();
                String string = null;
                try {
                    string = System.getProperty("dbxml.home") + "/docs/" + database.getName() + "_bootstrap.ior";
                    printWriter = new PrintWriter(new FileOutputStream(string), true);
                    printWriter.println(this.orb.object_to_string((Object)databaseServant._this(this.orb)));
                    printWriter.close();
                }
                catch (Exception exception) {
                    Debug.println((java.lang.Object)("Unable to bootstrap the instance '" + database.getName() + "' due to an error writing: " + string));
                }
                if (this.useNaming) {
                    printWriter = new NameComponent(database.getName(), "");
                    NameComponent[] nameComponentArray = new NameComponent[]{nameComponent, printWriter};
                    namingContextExt.bind(nameComponentArray, (Object)databaseServant._this(this.orb));
                    System.out.println(this.getName() + ": '" + (String)object + "' instance registered");
                }
                if (printStream != null) {
                    printStream.println((String)object);
                }
                ++n;
            }
            object = new Thread(this);
            ((Thread)object).setName("CORBA API Service");
            ((Thread)object).start();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            Debug.println((java.lang.Object)this, (java.lang.Object)exception);
            Debug.printStackTrace((Throwable)exception);
            Debug.println((java.lang.Object)"Most likely your CORBA naming service couldn't be reached.");
        }
        return 0;
    }

    public int stop() {
        return 0;
    }

    public int suspend() {
        return 0;
    }

    public int resume() {
        return 0;
    }

    public int uninitialize() {
        return 0;
    }

    public String getName() {
        return "APIService";
    }
}

