/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.server.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.Container;
import org.dbxml.core.Database;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.request.URIMapper;
import org.dbxml.server.Configuration;
import org.dbxml.server.ManagerService;
import org.dbxml.server.ServiceManager;
import org.dbxml.server.dbXMLException;
import org.dbxml.server.services.SocketServer;
import org.dbxml.xml.TextWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class GopherServer
extends SocketServer
implements ManagerService {
    private static final String WELCOME = "welcome";
    private static final String[] EmptyStrings = new String[0];
    private Database db = null;
    private String[] welcome = null;
    private ServiceManager serviceManager = null;

    public GopherServer() {
        this.port = 70;
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        Configuration configuration2 = configuration.getChild(WELCOME);
        if (configuration2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(configuration2.getValue(), "\r\n");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                arrayList.add(string);
            }
            this.welcome = arrayList.toArray(EmptyStrings);
        }
    }

    public String getProtocol() {
        return "gopher";
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public synchronized int initialize() {
        this.serverGroup = new ThreadGroup(this.getName());
        this.connectionGroup = new ThreadGroup(this.serverGroup, "Gopher Sessions");
        return 0;
    }

    public int start() {
        return super.start();
    }

    public void run() {
        if (!this.createServerSocket()) {
            return;
        }
        try {
            while (true) {
                new GopherSession(this.sock.accept()).start();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private class GopherSession
    extends Thread {
        private Socket sock = null;
        private String host = null;
        private String address = null;
        private PrintStream out = null;
        private DataInputStream in = null;
        private String resource = null;
        private String query = null;

        public GopherSession(Socket socket) {
            super("Gopher Session");
            this.setDaemon(true);
            this.sock = socket;
        }

        public void run() {
            try {
                this.sock.setTcpNoDelay(true);
                this.sock.setSoLinger(true, GopherServer.this.linger);
                this.sock.setSoTimeout(GopherServer.this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.address = this.sock.getInetAddress().getHostAddress();
            this.host = GopherServer.this.reverse ? this.sock.getInetAddress().getHostName() : this.address;
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.sock.getOutputStream(), 4096);
                this.out = new PrintStream(bufferedOutputStream);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.sock.getInputStream(), 256);
                this.in = new DataInputStream(bufferedInputStream);
                this.resource = this.in.readLine();
                boolean bl = false;
                if (this.resource.trim().length() == 0) {
                    this.displayDatabases();
                    bl = true;
                }
                if (!bl) {
                    int n = this.resource.indexOf(47, 1);
                    String string = "";
                    string = n != -1 ? this.resource.substring(1, n) : this.resource.substring(1, this.resource.length());
                    GopherServer.this.db = Database.getDatabase(string);
                    int n2 = this.resource.indexOf("\t");
                    if (n2 != -1) {
                        this.query = this.resource.substring(n2 + 1);
                        this.resource = this.resource.substring(0, n2);
                    }
                    URIMapper uRIMapper = GopherServer.this.db.getURIMapper(this.resource);
                    int n3 = uRIMapper.getObjectType();
                    switch (n3) {
                        case 1: {
                            this.displayDatabase();
                            break;
                        }
                        case 2: {
                            if (this.query == null) {
                                this.displayCollection(uRIMapper.getCollection());
                                break;
                            }
                            this.displayQuery(uRIMapper.getCollection());
                            break;
                        }
                        case 3: {
                            Container container = uRIMapper.getContainer();
                            this.displayDocument(container.getDocument());
                            GopherServer.this.kernel.logMessage(0, this.host, "GOPHER " + container.getCanonicalName());
                            break;
                        }
                        default: {
                            this.printInfo("No Such Object: " + this.resource);
                            this.printEOF();
                        }
                    }
                    uRIMapper.reclaim();
                }
                this.out.flush();
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void displayDatabases() {
            if (GopherServer.this.welcome != null) {
                int n = 0;
                while (n < GopherServer.this.welcome.length) {
                    this.printInfo(GopherServer.this.welcome[n]);
                    ++n;
                }
                this.printInfo("");
            }
            try {
                this.printInfo("dbXML Server:");
                this.printInfo("");
                String[] stringArray = Database.listDatabases();
                int n = 0;
                while (n < stringArray.length) {
                    this.printItem(stringArray[n], "/" + stringArray[n]);
                    ++n;
                }
                this.printEOF();
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }

        public void displayDatabase() {
            if (GopherServer.this.welcome != null) {
                int n = 0;
                while (n < GopherServer.this.welcome.length) {
                    this.printInfo(GopherServer.this.welcome[n]);
                    ++n;
                }
                this.printInfo("");
            }
            try {
                this.printInfo("dbXML Server: " + GopherServer.this.db.getCanonicalName());
                this.printInfo("");
                String[] stringArray = GopherServer.this.db.listCollections();
                int n = 0;
                while (n < stringArray.length) {
                    Collection collection = GopherServer.this.db.getCollection(stringArray[n]);
                    this.printItem(collection.getName(), collection.getCanonicalName());
                    ++n;
                }
                this.printEOF();
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }

        public void displayCollection(Collection collection) {
            try {
                Object object;
                String[] stringArray;
                String string = collection.getCanonicalName();
                this.printInfo("Collection: " + string);
                this.printInfo("");
                if (collection.getParentCollection() != null) {
                    stringArray = collection.getParentCollection();
                    this.printItem("[" + stringArray.getName() + "]", stringArray.getCanonicalName());
                } else {
                    this.printItem("[" + GopherServer.this.db.getName() + "]", GopherServer.this.db.getCanonicalName());
                }
                this.printSearch("[XPath Query]", collection.getCanonicalName());
                stringArray = collection.listCollections();
                int n = 0;
                while (n < stringArray.length) {
                    object = collection.getCollection(stringArray[n]);
                    this.printItem(((Collection)object).getName(), ((Collection)object).getCanonicalName());
                    ++n;
                }
                if (collection.getFiler() != null) {
                    object = collection.getFiler().getRecordSet();
                    this.displayRecordSet(collection, (RecordSet)object);
                }
                this.printEOF();
            }
            catch (dbXMLException dbXMLException2) {
                Debug.printStackTrace((Throwable)dbXMLException2);
            }
        }

        public void displayQuery(Collection collection) {
            try {
                String string = collection.getCanonicalName();
                this.printInfo("Search Results: [" + string + "] - " + this.query);
                this.printInfo("");
                this.printItem("[" + collection.getName() + "]", collection.getCanonicalName());
                this.printSearch("[XPath Query Again]", collection.getCanonicalName());
                NodeSet nodeSet = collection.queryCollection("XPath", this.query, null);
                if (nodeSet != null && nodeSet.hasMoreNodes()) {
                    StringBuffer stringBuffer = new StringBuffer("\n");
                    while (nodeSet.hasMoreNodes()) {
                        stringBuffer.append(TextWriter.toString(nodeSet.getNextNode()));
                        stringBuffer.append("\n");
                    }
                    try {
                        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
                        while (dataInputStream.available() > 0) {
                            String string2 = dataInputStream.readLine();
                            this.printInfo(string2);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.printInfo("");
                    this.printInfo("No Document Found: " + this.query);
                }
                this.printEOF();
            }
            catch (dbXMLException dbXMLException2) {
                Debug.printStackTrace((Throwable)dbXMLException2);
            }
        }

        public void displayDocument(Document document) {
            try {
                TextWriter.write((Node)document, this.out);
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }

        public void displayRecordSet(Collection collection, RecordSet recordSet) {
            if (recordSet != null) {
                try {
                    while (recordSet.hasMoreRecords()) {
                        Key key = recordSet.getNextKey();
                        this.printFile(key, collection.getCanonicalName());
                    }
                }
                catch (Exception exception) {
                    this.printInfo("Error displaying RecordSet");
                }
            }
        }

        public void printInfo(String string) {
            string = string.replace('\t', ' ');
            this.out.print('i');
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<>&", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("<")) {
                    this.out.print("&lt;");
                    continue;
                }
                if (string2.equals(">")) {
                    this.out.print("&gt;");
                    continue;
                }
                if (string2.equals("&")) {
                    this.out.print("&amp;");
                    continue;
                }
                this.out.print(string2);
            }
            this.out.print("\tinfo\t1\r\n");
        }

        public void printServer() {
            this.out.print('\t');
            this.out.print(GopherServer.this.hostname);
            this.out.print('\t');
            this.out.print(GopherServer.this.port);
            this.out.print("\r\n");
        }

        public void printItem(String string, String string2) {
            this.out.print('1');
            this.out.print(string);
            this.out.print('\t');
            this.out.print(string2);
            this.printServer();
        }

        public void printSearch(String string, String string2) {
            this.out.print('7');
            this.out.print(string);
            this.out.print('\t');
            this.out.print(string2);
            this.printServer();
        }

        public void printFile(Key key, String string) {
            String string2 = key.toString();
            this.out.print('0');
            this.out.print(string2);
            this.out.print('\t');
            this.out.print(string);
            this.out.print('/');
            this.out.print(string2);
            this.printServer();
        }

        public void printEOF() {
            this.out.print(".\r\n");
        }
    }
}

