/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.objects.SimpleXMLObject;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Sequencer
extends SimpleXMLObject {
    private static final String PREFIX = "[sequencer]";
    private static final String SEQUENCES = "sequences";
    private static final String SEQUENCE = "sequence";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private Map values = Collections.synchronizedMap(new HashMap());
    private boolean loaded = false;
    private Collection sysObj;
    private String docKey;
    private DocumentImpl doc;
    public static final String[] PARAMS_create = new String[]{"name"};
    public static final String[] PARAMS_createValue = new String[]{"name", "value"};
    public static final String[] PARAMS_remove = new String[]{"name"};
    public static final String[] PARAMS_reset = new String[]{"name", "value"};
    public static final String[] PARAMS_next = new String[]{"name"};

    private void checkLoaded() {
        if (this.loaded) {
            return;
        }
        try {
            this.sysObj = this.collection.getSystemCollection().getCollection("SysObjects");
            this.docKey = PREFIX + this.collection.getCanonicalName();
            this.doc = (DocumentImpl)this.sysObj.getDocument(this.docKey);
            if (this.doc != null) {
                Element element = this.doc.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName(SEQUENCE);
                int n = 0;
                while (n < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(n);
                    String string = element2.getAttribute(NAME);
                    long l = Long.parseLong(element2.getAttribute(VALUE));
                    this.values.put(string, new SequenceValue(element2, l));
                    ++n;
                }
            } else {
                this.doc = new DocumentImpl();
                this.doc.setSymbols(this.sysObj.getSymbols());
                this.doc.appendChild(this.doc.createElement(SEQUENCES));
            }
            this.loaded = true;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public void create(String string) {
        this.checkLoaded();
        SequenceValue sequenceValue = (SequenceValue)this.values.get(string);
        if (sequenceValue == null) {
            Element element = this.doc.createElement(SEQUENCE);
            element.setAttribute(NAME, string);
            element.setAttribute(VALUE, "0");
            this.doc.getDocumentElement().appendChild(element);
            this.values.put(string, new SequenceValue(element, 0L));
            this.write();
        }
    }

    public void createValue(String string, long l) {
        this.checkLoaded();
        SequenceValue sequenceValue = (SequenceValue)this.values.get(string);
        if (sequenceValue == null) {
            Element element = this.doc.createElement(SEQUENCE);
            element.setAttribute(NAME, string);
            element.setAttribute(VALUE, Long.toString(l));
            this.doc.getDocumentElement().appendChild(element);
            this.values.put(string, new SequenceValue(element, l));
            this.write();
        }
    }

    public void remove(String string) {
        this.checkLoaded();
        SequenceValue sequenceValue = (SequenceValue)this.values.get(string);
        if (sequenceValue != null) {
            this.doc.removeChild(sequenceValue.elem);
            this.values.remove(string);
            this.write();
        }
    }

    public void reset(String string, long l) {
        this.checkLoaded();
        SequenceValue sequenceValue = (SequenceValue)this.values.get(string);
        if (sequenceValue != null) {
            sequenceValue.reset(l);
        }
    }

    public long next(String string) {
        this.checkLoaded();
        SequenceValue sequenceValue = (SequenceValue)this.values.get(string);
        if (sequenceValue != null) {
            return sequenceValue.next();
        }
        return -1L;
    }

    private void write() {
        try {
            this.sysObj.setDocument(this.docKey, this.doc);
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    private class SequenceValue {
        private Element elem;
        private long value;

        public SequenceValue(Element element) {
            this.elem = element;
            this.value = 0L;
        }

        public SequenceValue(Element element, long l) {
            this.elem = element;
            this.value = l;
        }

        public synchronized void reset(long l) {
            this.value = l;
            this.write();
        }

        public synchronized long next() {
            ++this.value;
            this.write();
            return this.value;
        }

        private void write() {
            this.elem.setAttribute(Sequencer.VALUE, Long.toString(this.value));
            Sequencer.this.write();
        }
    }
}

