/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.xupdate;

import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.query.CompilationException;
import org.dbxml.core.query.NodeListSet;
import org.dbxml.core.query.ProcessingException;
import org.dbxml.core.query.Query;
import org.dbxml.core.query.QueryEngine;
import org.dbxml.core.query.QueryException;
import org.dbxml.core.query.QueryResolver;
import org.dbxml.core.xupdate.XUpdateImpl;
import org.dbxml.server.Configuration;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class XUpdateQueryResolver
extends SimpleConfigurable
implements QueryResolver {
    private static final String XUPDATE_XPATH_PROP = "org.infozone.tools.xml.queries.XPathQueryFactory";
    private static final String XUPDATE_XPATH_IMPL = "org.dbxml.core.xupdate.XPathQueryFactoryImpl";
    public static final String STYLE_XUPDATE = "XUpdate";
    private QueryEngine engine;

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
    }

    public String getQueryStyle() {
        return STYLE_XUPDATE;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.engine = queryEngine;
    }

    public Query compileQuery(Collection collection, String string, NamespaceMap namespaceMap, Key[] keyArray) throws QueryException {
        return new XUpdateQuery(collection, string, namespaceMap, keyArray);
    }

    public NodeSet query(Collection collection, String string, NamespaceMap namespaceMap, Key[] keyArray) throws QueryException {
        XUpdateQuery xUpdateQuery = new XUpdateQuery(collection, string, namespaceMap, keyArray);
        return xUpdateQuery.execute();
    }

    static {
        System.setProperty(XUPDATE_XPATH_PROP, XUPDATE_XPATH_IMPL);
    }

    private class XUpdateQuery
    implements Query {
        public Collection context;
        public String query;
        public NamespaceMap nsMap;
        public XUpdateImpl xu;
        public Key[] keys;

        public XUpdateQuery(Collection collection, String string, NamespaceMap namespaceMap, Key[] keyArray) throws QueryException {
            this.context = collection;
            this.query = string;
            this.nsMap = namespaceMap;
            this.keys = keyArray;
            try {
                this.xu = new XUpdateImpl();
                this.xu.setQString(string);
            }
            catch (Exception exception) {
                throw new CompilationException("Error Compiling XUpdate Query");
            }
        }

        public String getQueryStyle() {
            return XUpdateQueryResolver.STYLE_XUPDATE;
        }

        public Collection getQueryContext() {
            return this.context;
        }

        public String getQueryString() {
            return this.query;
        }

        public NamespaceMap getNamespaceMap() {
            return this.nsMap;
        }

        public Key[] getKeySet() {
            return this.keys;
        }

        public NodeSet execute() throws QueryException {
            try {
                Node node;
                if (this.keys != null) {
                    try {
                        int n = 0;
                        while (n < this.keys.length) {
                            node = this.context.getDocument(this.keys[n]);
                            this.xu.execute(node.getDocumentElement());
                            this.context.setDocument(this.keys[n], (Document)node);
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                } else {
                    this.xu.execute(this.context);
                }
                DocumentImpl documentImpl = new DocumentImpl();
                node = documentImpl.createElementNS("http://www.dbxml.org/Query", "src:modified");
                node.setAttribute("xmlns:src", "http://www.dbxml.org/Query");
                documentImpl.appendChild(node);
                Text text = documentImpl.createTextNode(Integer.toString(this.xu.getModifiedCount()));
                node.appendChild(text);
                return new NodeListSet(documentImpl.getChildNodes());
            }
            catch (Exception exception) {
                throw new ProcessingException("Error executing XUpdate query");
            }
        }
    }
}

