/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.tests;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;

public class BTreeTest {
    public static void main(String[] stringArray) {
        try {
            if (stringArray[0].equals("create")) {
                BTree bTree = new BTree(new File(stringArray[1]));
                bTree.create();
            } else if (stringArray[0].equals("import")) {
                BTree bTree = new BTree(new File(stringArray[1]));
                bTree.open();
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                int n = 0;
                while (dataInputStream.available() > 0) {
                    String string = dataInputStream.readLine().trim();
                    if (string.length() <= 0) continue;
                    if (string.indexOf("/") >= 0) {
                        string = string.substring(0, string.indexOf("/"));
                    }
                    bTree.addValue(new Value(string), n++);
                }
                fileInputStream.close();
                bTree.close();
            } else if (stringArray[0].equals("export")) {
                BTree bTree = new BTree(new File(stringArray[1]));
                bTree.open();
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                final PrintStream printStream = new PrintStream(fileOutputStream);
                bTree.query(null, new BTreeCallback(){

                    public boolean indexInfo(Value value, long l) {
                        printStream.println(value);
                        return true;
                    }
                });
                fileOutputStream.close();
                bTree.close();
            } else if (stringArray[0].equals("find")) {
                BTree bTree = new BTree(new File(stringArray[1]));
                bTree.open();
                long l = bTree.findValue(new Value(stringArray[2]));
                System.out.println("Result = " + l);
                bTree.close();
            }
        }
        catch (Exception exception) {
            System.out.println("usage:");
            System.out.println("   create <btree>");
            System.out.println("      Create a new B+Tree file");
            System.out.println();
            System.out.println("   import <btree> <import file>");
            System.out.println("      Import text line by line into B+Tree");
            System.out.println();
            System.out.println("   export <btree> <export file>");
            System.out.println("      Export values line by line from B+Tree");
            System.out.println();
            System.out.println("   find <btree> <value>");
            System.out.println("      Find value in the B+Tree");
        }
    }
}

