/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.dbxml.client.xmldb.DatabaseImpl;
import org.dbxml.server.dbXMLException;
import org.dbxml.server.util.StringUtilities;
import org.dbxml.tools.ArgTokenizer;
import org.dbxml.tools.command.Command;
import org.dbxml.xml.dom.DOMParser;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.UNKNOWN;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

abstract class XMLTools {
    public static final String COLLECTION = "collection";
    public static final String EXTENSION = "extension";
    public static final String FILE_PATH = "filePath";
    public static final String ACTION = "action";
    public static final String IMPL_CLASS = "implClass";
    public static final String NAME_OF = "nameOf";
    public static final String XML_OBJECT_URI = "xmlobjecturi";
    public static final String PATTERN = "pattern";
    public static final String QUERY = "query";
    public static final String URI = "uri";
    public static final String VERBOSE = "verbose";
    public static final String FORCE = "force";
    public static final String TYPE = "type";
    public static final String PAGE_SIZE = "pagesize";
    public static final String MAX_KEY_SIZE = "maxkeysize";
    public static final String DB_SERVER = "dbServ";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String AUTO_KEY = "autoKey";
    private Hashtable table = new Hashtable();
    private static boolean verbose = false;
    protected String location = null;
    private boolean initialized = false;
    private Document commandsDocument = null;
    protected NodeList commandsList = null;

    public XMLTools() {
        this.table.put(FILE_PATH, "");
        this.table.put(EXTENSION, "");
        this.table.put(QUERY, "");
        this.table.put(AUTO_KEY, "");
        this.table.put(FORCE, "");
        this.table.put(VERBOSE, "false");
    }

    public void init() throws dbXMLException, FileNotFoundException {
        if (!this.initialized) {
            this.initCommandsDocument();
            this.initCommandsList();
            this.initialized = true;
        }
    }

    protected void initCommandsDocument() throws dbXMLException, FileNotFoundException {
        File file = new File(System.getProperty("dbxml.home"));
        File file2 = new File(file, "config/commands.xml");
        DOMParser dOMParser = new DOMParser();
        this.commandsDocument = DOMParser.toDocument(new FileInputStream(file2));
    }

    protected abstract void initCommandsList();

    protected Document getCommandsDocument() {
        return this.commandsDocument;
    }

    protected NodeList getCommands() {
        return this.commandsList;
    }

    public abstract boolean isAdmin();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(String[] stringArray) throws dbXMLException, Exception {
        try {
            this.init();
            ArgTokenizer argTokenizer = new ArgTokenizer(stringArray);
            if (!argTokenizer.hasMoreTokens()) {
                this.printHelp();
                return;
            }
            this.table.put(ACTION, argTokenizer.nextToken());
            while (true) {
                if (!argTokenizer.hasMoreTokens()) {
                    if (this.execute()) return;
                    this.printHelp();
                    return;
                }
                String string = argTokenizer.nextToken();
                if (string.equalsIgnoreCase("-c") || string.equalsIgnoreCase("--collection")) {
                    this.table.put(COLLECTION, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-e") || string.equalsIgnoreCase("--extension")) {
                    this.table.put(EXTENSION, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-f") || string.equalsIgnoreCase("--filepath")) {
                    this.table.put(FILE_PATH, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-h") || string.equalsIgnoreCase("--help")) {
                    this.table.put(ACTION, "help");
                    continue;
                }
                if (string.equalsIgnoreCase("-i") || string.equalsIgnoreCase("--implementclass")) {
                    this.table.put(IMPL_CLASS, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-n") || string.equalsIgnoreCase("--nameOf")) {
                    this.table.put(NAME_OF, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-o") || string.equalsIgnoreCase("--xmlobjecturi")) {
                    this.table.put(XML_OBJECT_URI, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-p") || string.equalsIgnoreCase("--pattern")) {
                    this.table.put(PATTERN, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-q") || string.equalsIgnoreCase("--query")) {
                    this.table.put(QUERY, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-u") || string.equalsIgnoreCase("--uri")) {
                    this.table.put(URI, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("-v") || string.equalsIgnoreCase("--verbose")) {
                    this.table.put(VERBOSE, "true");
                    continue;
                }
                if (string.equalsIgnoreCase("-y") || string.equalsIgnoreCase("--yes_force")) {
                    this.table.put(FORCE, "yes");
                    continue;
                }
                if (string.equalsIgnoreCase("-t") || string.equalsIgnoreCase("--type")) {
                    this.table.put(TYPE, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (string.equalsIgnoreCase("+trim")) {
                    if (this.table.containsKey(TYPE)) continue;
                    this.table.put(TYPE, "trimmed");
                    continue;
                }
                if (string.equalsIgnoreCase("-trim")) {
                    if (this.table.containsKey(TYPE)) continue;
                    this.table.put(TYPE, "string");
                    continue;
                }
                if (string.equalsIgnoreCase("--pagesize")) {
                    this.table.put(PAGE_SIZE, argTokenizer.nextSwitchToken());
                    continue;
                }
                if (!string.equalsIgnoreCase("--maxkeysize")) continue;
                this.table.put(MAX_KEY_SIZE, argTokenizer.nextSwitchToken());
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new BAD_PARAM("ERROR : " + (Object)((Object)bAD_PARAM) + " One or more parameters not found");
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            throw new COMM_FAILURE("ERROR : " + (Object)((Object)cOMM_FAILURE) + " Verify the dbXML server is running");
        }
        catch (UNKNOWN uNKNOWN) {
            throw new UNKNOWN("ERROR : " + (Object)((Object)uNKNOWN) + " Parameters were not entered correctly");
        }
        catch (MARSHAL mARSHAL) {
            throw new MARSHAL("ERROR : " + (Object)((Object)mARSHAL) + " One or more parameters not found");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("ERROR : " + noSuchElementException + " Switch found. Parameter missing.");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(System.out);
            throw new NullPointerException("ERROR : " + nullPointerException);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new dbXMLException("ERROR : " + exception);
        }
    }

    public boolean execute() throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        Object object;
        this.init();
        String string = (String)this.table.get(ACTION);
        String string2 = null;
        if (string != null) {
            object = this.getCommands();
            int n = 0;
            while (n < object.getLength()) {
                Element element = (Element)object.item(n);
                if (string.equals(element.getAttribute("switch")) || string.equals(element.getAttribute("name"))) {
                    string2 = element.getAttribute("class");
                }
                ++n;
            }
        }
        if (string2 != null) {
            object = new DatabaseImpl();
            if (this.table.containsKey(URI)) {
                String string3 = (String)this.table.get(URI);
                object.setProperty("dbxml.naming.ior", string3 + "/NamingService");
            }
            DatabaseManager.registerDatabase((Database)object);
            object = (Command)Class.forName(string2).newInstance();
            ((Command)object).execute(this.table);
            return true;
        }
        return false;
    }

    public boolean handleOption(String string, ArgTokenizer argTokenizer) {
        return false;
    }

    public void setAction(String string) {
        this.table.put(ACTION, string);
    }

    public String getAction() {
        return (String)this.table.get(ACTION);
    }

    public void setCollectionName(String string) {
        this.table.put(COLLECTION, string);
    }

    public String getCollectionName() {
        return (String)this.table.get(COLLECTION);
    }

    public void setDocumentName(String string) {
        this.table.put(NAME_OF, string);
    }

    public String getDocumentName() {
        return (String)this.table.get(NAME_OF);
    }

    public void setQuery(String string) {
        this.table.put(QUERY, string);
    }

    public String getQuery() {
        return (String)this.table.get(QUERY);
    }

    public void setName(String string) {
        this.table.put(NAME_OF, string);
    }

    public String getName() {
        return (String)this.table.get(NAME_OF);
    }

    public void setDatabaseServer(String string) {
        this.table.put(DB_SERVER, string);
    }

    public String getDatabaseServer() {
        return (String)this.table.get(DB_SERVER);
    }

    public void setPort(String string) {
        this.table.put(PORT, string);
    }

    public String getPort() {
        return (String)this.table.get(PORT);
    }

    public void setHost(String string) {
        this.table.put(HOST, string);
    }

    public String getHost() {
        return (String)this.table.get(HOST);
    }

    public void setFilePath(String string) {
        this.table.put(FILE_PATH, string);
    }

    public String getFilePath() {
        return (String)this.table.get(FILE_PATH);
    }

    public void setURI(String string) {
        this.table.put(URI, string);
    }

    public String getURI() {
        return (String)this.table.get(URI);
    }

    public void setImplementClass(String string) {
        this.table.put(IMPL_CLASS, string);
    }

    public String getImplementClass() {
        return (String)this.table.get(IMPL_CLASS);
    }

    public void setUser(String string) {
        this.table.put(USER, string);
    }

    public String getUser() {
        return (String)this.table.get(USER);
    }

    public void setPassword(String string) {
        this.table.put(PASSWORD, string);
    }

    public String getPassword() {
        return (String)this.table.get(PASSWORD);
    }

    public void printHelp() {
        String string;
        String string2;
        String string3;
        NodeList nodeList = this.getCommands();
        System.out.println();
        System.out.println("dbXMLAdmin Command Tools v1.0b4");
        System.out.println();
        System.out.println("Format: dbxml action [switch] [parameter]");
        System.out.println();
        System.out.println("Where:  [switch]  implements:");
        System.out.println("    -c           Collection context (must always be specified)");
        System.out.println("    -e           File extension for multiple documents");
        System.out.println("    -f           File path for document retrieval and storage");
        System.out.println("    -i           Implementing Class for XMLObjects");
        System.out.println("    -n           Name");
        System.out.println("    -o           URI String for invocation of XMLObject");
        System.out.println("    -p           Index pattern");
        System.out.println("    -q           Query string");
        System.out.println("    -u           Database URI");
        System.out.println("    -y           Force Deletion process");
        System.out.println("    -t           Specify the data type in collection index");
        System.out.println("    --pagesize   Page size for Index Pages (default: 1024) ");
        System.out.println("    --maxkeysize The max key size for values (default: 0=none )");
        System.out.println();
        System.out.println("\nActions:\n");
        System.out.println("    dbxml [parameter], etc...\n");
        int n = 0;
        while (n < nodeList.getLength()) {
            string3 = ((Element)nodeList.item(n)).getAttribute("helpclass");
            if (string3.equals("document")) {
                string2 = ((Element)nodeList.item(n)).getAttribute("description");
                string = ((Element)nodeList.item(n)).getAttribute("switch");
                System.out.println("    " + StringUtilities.leftJustify((String)string, (int)13) + string2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            string3 = ((Element)nodeList.item(n2)).getAttribute("helpclass");
            if (string3.equals("security")) {
                string2 = ((Element)nodeList.item(n2)).getAttribute("description");
                string = ((Element)nodeList.item(n2)).getAttribute("switch");
                System.out.println("    " + StringUtilities.leftJustify((String)string, (int)13) + string2);
            }
            ++n2;
        }
        System.out.println("\nExamples:\n");
        System.out.println("    dbxml ad -c /db/test -f /tmp/xmldocument -n myxmldocument");
        System.out.println("    dbxml dd -c /db/test -n myxmldocument");
        System.out.println("    dbxml rd -c /db/test/ocs -f a:\\file.xml -n file.xml");
        System.out.println("    dbxml xpath -c /db/test/ocs -q test");
        System.out.println();
        System.out.println("For more information, please read the dbXML - Tools Reference Guide");
        System.out.println();
    }
}

