/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.XMLSerializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymbolTable
implements XMLSerializable {
    static final String SYMBOLS = "symbols";
    static final String SYMBOL = "symbol";
    static final String NAME = "name";
    static final String NSURI = "nsuri";
    static final String ID = "id";
    private transient boolean dirty = false;
    private transient long lastModified = System.currentTimeMillis();
    private Map symbols = new HashMap();
    private Map names = new HashMap();
    private short maxSymbol = (short)-1;

    public SymbolTable() {
    }

    public SymbolTable(Element element) {
        this.streamFromXML(element);
    }

    public static final String getLookupName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append('[');
        stringBuffer.append(string2);
        stringBuffer.append(']');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final short getNormalizedSymbol(SymbolTable symbolTable, String string, NamespaceMap namespaceMap, boolean bl) {
        if (string.startsWith("[")) {
            int n = string.indexOf(93);
            String string2 = string.substring(1, n);
            int n2 = string.indexOf(n + 1, 58);
            String string3 = n2 != -1 ? string.substring(n2 + 1) : string.substring(n + 1);
            return symbolTable.getSymbol(SymbolTable.getNormalizedLocalName(string3, string2), string2, bl);
        }
        int n = string.indexOf(58);
        if (n != -1) {
            String string4 = string.substring(0, n);
            String string5 = (String)namespaceMap.get(string4);
            if (string5 != null) {
                String string6 = string.substring(n + 1);
                return symbolTable.getSymbol(SymbolTable.getNormalizedLocalName(string6, string5), string5, bl);
            }
            return symbolTable.getSymbol(string);
        }
        return symbolTable.getSymbol(string, bl);
    }

    public static final String getNormalizedLocalName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("ns");
        stringBuffer.append(Integer.toString(string2.hashCode()));
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String getNormalizedQName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("ns");
        stringBuffer.append(Integer.toString(string2.hashCode()));
        stringBuffer.append(':');
        int n = string.indexOf(58);
        if (n != -1) {
            stringBuffer.append(string.substring(n + 1));
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean bl) {
        this.dirty = bl;
        this.lastModified = System.currentTimeMillis();
    }

    public final SymbolInfo getSymbolInfo(String string, String string2) {
        String string3 = SymbolTable.getLookupName(string, string2);
        return (SymbolInfo)this.symbols.get(string3);
    }

    public final short getSymbol(String string, String string2, boolean bl) {
        String string3 = SymbolTable.getLookupName(string, string2);
        SymbolInfo symbolInfo = (SymbolInfo)this.symbols.get(string3);
        if (symbolInfo != null) {
            return symbolInfo.symbol;
        }
        if (bl) {
            Map map = this.symbols;
            synchronized (map) {
                short s = this.maxSymbol = (short)(this.maxSymbol + 1);
                symbolInfo = new SymbolInfo(string, string2, s);
                this.symbols.put(string3, symbolInfo);
                this.names.put(new Short(s), symbolInfo);
                this.setDirty(true);
                short s2 = s;
                return s2;
            }
        }
        return -1;
    }

    public final short getSymbol(String string, boolean bl) {
        SymbolInfo symbolInfo = (SymbolInfo)this.symbols.get(string);
        if (symbolInfo != null) {
            return symbolInfo.symbol;
        }
        if (bl) {
            Map map = this.symbols;
            synchronized (map) {
                short s = this.maxSymbol = (short)(this.maxSymbol + 1);
                symbolInfo = new SymbolInfo(string, s);
                this.symbols.put(string, symbolInfo);
                this.names.put(new Short(s), symbolInfo);
                this.setDirty(true);
                short s2 = s;
                return s2;
            }
        }
        return -1;
    }

    public final short getSymbol(String string, String string2) {
        return this.getSymbol(string, string2, false);
    }

    public final short getSymbol(String string) {
        return this.getSymbol(string, false);
    }

    public final SymbolInfo getSymbolInfo(short s) {
        return (SymbolInfo)this.names.get(new Short(s));
    }

    public final String getNamespaceURI(short s) {
        SymbolInfo symbolInfo = this.getSymbolInfo(s);
        return symbolInfo != null ? symbolInfo.namespaceURI : null;
    }

    public final String getName(short s) {
        SymbolInfo symbolInfo = this.getSymbolInfo(s);
        return symbolInfo != null ? symbolInfo.qname : null;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final Element streamToXML(Document document) throws DOMException {
        Element element = document.createElement(SYMBOLS);
        document.appendChild(element);
        Iterator iterator = this.symbols.values().iterator();
        while (iterator.hasNext()) {
            SymbolInfo symbolInfo = (SymbolInfo)iterator.next();
            Element element2 = document.createElement(SYMBOL);
            element2.setAttribute(NAME, symbolInfo.qname);
            if (symbolInfo.namespaceURI != null && symbolInfo.namespaceURI.length() > 0) {
                element2.setAttribute(NSURI, symbolInfo.namespaceURI);
            }
            element2.setAttribute(ID, Short.toString(symbolInfo.symbol));
            element.appendChild(element2);
        }
        return element;
    }

    public final void streamFromXML(Element element) throws DOMException {
        this.symbols.clear();
        this.names.clear();
        this.maxSymbol = (short)-1;
        NodeList nodeList = element.getElementsByTagName(SYMBOL);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Short s;
            Element element2 = (Element)nodeList.item(n2);
            String string = element2.getAttribute(NAME);
            String string2 = element2.getAttribute(NSURI);
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if ((s = new Short(element2.getAttribute(ID))) > this.maxSymbol) {
                this.maxSymbol = s;
            }
            SymbolInfo symbolInfo = new SymbolInfo(string, string2, s);
            if (string2 != null) {
                String string3 = SymbolTable.getLookupName(string, string2);
                this.symbols.put(string3, symbolInfo);
            } else {
                this.symbols.put(string, symbolInfo);
            }
            this.names.put(s, symbolInfo);
            ++n2;
        }
    }

    public final class SymbolInfo
    implements Serializable {
        public String namespaceURI;
        public String qname;
        public short symbol;

        public SymbolInfo(String string, String string2, short s) {
            this.qname = string;
            this.namespaceURI = string2;
            this.symbol = s;
        }

        public SymbolInfo(String string, short s) {
            this.qname = string;
            this.symbol = s;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getQName() {
            return this.qname;
        }

        public short getSymbolID() {
            return this.symbol;
        }
    }
}

