/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.dbxml.Debug;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class TextWriter {
    private Node node = null;

    public TextWriter(Node node) throws DOMException {
        this.node = node;
    }

    public TextWriter(Document document) {
        this.node = document;
    }

    public TextWriter(Element element) {
        this.node = element;
    }

    public TextWriter(DocumentFragment documentFragment) {
        this.node = documentFragment;
    }

    private void writeNode(Writer writer, Node node) throws IOException {
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>\n");
                this.writeChildren(writer, node);
                break;
            }
            case 11: {
                this.writeChildren(writer, node);
                break;
            }
            case 10: {
                Debug.println((Object)"can't serialize doctype yet");
                break;
            }
            case 1: {
                Element element = (Element)node;
                String string = element.getTagName();
                writer.write(60);
                writer.write(string);
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr = (Attr)namedNodeMap.item(n2);
                    writer.write(32);
                    this.writeNode(writer, attr);
                    ++n2;
                }
                if (element.hasChildNodes()) {
                    writer.write(62);
                    this.writeChildren(writer, node);
                    writer.write("</");
                    writer.write(string);
                    writer.write(62);
                    break;
                }
                writer.write(" />");
                break;
            }
            case 2: {
                Attr attr = (Attr)node;
                writer.write(attr.getName());
                writer.write("=\"");
                this.writeEscapedText(writer, attr.getValue());
                writer.write("\"");
                break;
            }
            case 5: {
                Debug.println((Object)"can't serialize entity ref yet");
                break;
            }
            case 6: {
                Debug.println((Object)"can't serialize entity yet");
                break;
            }
            case 12: {
                Debug.println((Object)"can't serialize notation yet");
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                writer.write("<?");
                writer.write(processingInstruction.getTarget());
                writer.write(" ");
                writer.write(processingInstruction.getData());
                writer.write("?>\n");
                break;
            }
            case 3: {
                this.writeEscapedText(writer, node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
            }
        }
    }

    private void writeChildren(Writer writer, Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.writeNode(writer, nodeList.item(n2));
            ++n2;
        }
    }

    private void writeEscapedText(Writer writer, String string) throws IOException {
        char[] cArray = string.toCharArray();
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            switch (cArray[n3]) {
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\'': {
                    string2 = "&apos;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                default: {
                    ++n2;
                }
            }
            if (string2 != null) {
                if (n2 > 0) {
                    writer.write(cArray, n, n2);
                }
                writer.write(string2);
                n = n3 + 1;
                n2 = 0;
                string2 = null;
            }
            ++n3;
        }
        if (n2 > 0) {
            writer.write(cArray, n, n2);
        }
    }

    public static void write(Node node, Writer writer) throws IOException {
        new TextWriter(node).write(writer);
    }

    public void write(Writer writer) throws IOException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(writer, 4096);
            this.writeNode(bufferedWriter, this.node);
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public static void write(Node node, OutputStream outputStream) throws IOException {
        new TextWriter(node).write(outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, 4096);
            this.writeNode(bufferedWriter, this.node);
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public static String toString(Node node) {
        return new TextWriter(node).toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.write(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            return null;
        }
    }
}

