/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dbxml.xml.SymbolTable;

public class XMLCompressedInput
extends DataInputStream {
    private byte signature = 0;
    private SymbolTable st = null;

    public XMLCompressedInput(InputStream inputStream, SymbolTable symbolTable) {
        super(inputStream);
        this.st = symbolTable;
    }

    public final byte readSignature() throws IOException {
        this.signature = this.readByte();
        return this.signature;
    }

    public final byte getSignature() {
        return this.signature;
    }

    public final short getNodeType() {
        byte by = (byte)((this.signature & 0xC0) >> 6);
        switch (by) {
            case 0: {
                by = (byte)((this.signature & 0x20) >> 5);
                if (by == 0) {
                    return 3;
                }
                return 5;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 7;
            }
            case 3: {
                by = (byte)((this.signature & 0x3C) >> 2);
                switch (by) {
                    case 4: {
                        return 4;
                    }
                    case 6: {
                        return 6;
                    }
                    case 8: {
                        return 8;
                    }
                    case 10: {
                        return 10;
                    }
                    case 12: {
                        return 12;
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    public final int readContentSize() throws IOException {
        int n = 0;
        short s = this.getNodeType();
        switch (s) {
            case 1: 
            case 3: {
                n = (byte)((this.signature & 0xC) >> 2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n = 1;
                break;
            }
            case 12: {
                n = (byte)(this.signature & 3);
            }
        }
        switch (n) {
            case 3: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 1: {
                return this.readInt();
            }
        }
        return 0;
    }

    public final int readAttributeCount() throws IOException {
        int n = 0;
        if (this.getNodeType() == 1) {
            n = (byte)(this.signature & 3);
        }
        switch (n) {
            case 3: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 1: {
                return this.readInt();
            }
        }
        return 0;
    }
}

