/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.dom;

import java.io.InputStream;
import org.dbxml.Debug;
import org.dbxml.server.util.ByteArrayInput;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.XMLCompressedInput;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    public CharacterDataImpl() {
    }

    public CharacterDataImpl(NodeImpl nodeImpl, byte[] byArray, int n, int n2) {
        super(nodeImpl, byArray, n, n2);
    }

    public CharacterDataImpl(NodeImpl nodeImpl, boolean bl) {
        super(nodeImpl, bl);
    }

    public CharacterDataImpl(NodeImpl nodeImpl, String string) {
        super(nodeImpl, true);
        if (string == null) {
            string = "";
        }
        this.nodeValue = string;
    }

    protected final void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            if (this.data != null) {
                DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
                SymbolTable symbolTable = documentImpl.getSymbols();
                ByteArrayInput byteArrayInput = new ByteArrayInput(this.data, this.pos, this.len);
                XMLCompressedInput xMLCompressedInput = new XMLCompressedInput((InputStream)byteArrayInput, symbolTable);
                xMLCompressedInput.readSignature();
                if (this.getNodeType() == 3) {
                    xMLCompressedInput.readContentSize();
                } else {
                    xMLCompressedInput.readInt();
                }
                byte[] byArray = new byte[byteArrayInput.available()];
                xMLCompressedInput.read(byArray);
                this.nodeValue = new String(byArray);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public final void setNodeValue(String string) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (string == null) {
            string = "";
        }
        this.nodeValue = string;
        this.setDirty();
    }

    public final String substringData(int n, int n2) throws DOMException {
        try {
            return this.nodeValue.substring(n, n + n2);
        }
        catch (Exception exception) {
            throw NodeImpl.EX_INDEX_SIZE;
        }
    }

    public final String getData() throws DOMException {
        return this.getNodeValue();
    }

    public final void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public final void insertData(int n, String string) throws DOMException {
        String string2 = this.getNodeValue();
        this.checkReadOnly();
        try {
            this.setNodeValue(string2.substring(0, n) + string + string2.substring(n + 1));
        }
        catch (Exception exception) {
            throw NodeImpl.EX_INDEX_SIZE;
        }
    }

    public final int getLength() {
        return this.getNodeValue().length();
    }

    public final void replaceData(int n, int n2, String string) throws DOMException {
        String string2 = this.getNodeValue();
        this.checkReadOnly();
        try {
            this.setNodeValue(string2.substring(0, n) + string + string2.substring(n + n2));
        }
        catch (Exception exception) {
            throw NodeImpl.EX_INDEX_SIZE;
        }
    }

    public final void appendData(String string) throws DOMException {
        String string2 = this.getNodeValue();
        this.checkReadOnly();
        this.setNodeValue(string2 + string);
    }

    public final void deleteData(int n, int n2) throws DOMException {
        String string = this.getNodeValue();
        this.checkReadOnly();
        try {
            this.setNodeValue(string.substring(0, n) + string.substring(n + n2));
        }
        catch (Exception exception) {
            throw NodeImpl.EX_INDEX_SIZE;
        }
    }
}

