/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.dbxml.Debug;
import org.dbxml.server.util.ByteArrayInput;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.XMLCompressedInput;
import org.dbxml.xml.dom.CDATASectionImpl;
import org.dbxml.xml.dom.CommentImpl;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.dom.ElementImpl;
import org.dbxml.xml.dom.EntityImpl;
import org.dbxml.xml.dom.EntityReferenceImpl;
import org.dbxml.xml.dom.NodeImpl;
import org.dbxml.xml.dom.NodeListImpl;
import org.dbxml.xml.dom.NotationImpl;
import org.dbxml.xml.dom.ProcessingInstructionImpl;
import org.dbxml.xml.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public abstract class ContainerNodeImpl
extends NodeImpl {
    protected NodeListImpl childNodes = new NodeListImpl(this);

    public ContainerNodeImpl() {
    }

    public ContainerNodeImpl(NodeImpl nodeImpl, byte[] byArray, int n, int n2) {
        super(nodeImpl, byArray, n, n2);
    }

    public ContainerNodeImpl(NodeImpl nodeImpl, boolean bl) {
        super(nodeImpl, bl);
    }

    protected boolean isNodeTypeValid(short s) {
        return true;
    }

    protected final Node getPreviousSibling(Node node) {
        this.checkLoaded();
        int n = this.childNodes.indexOf(node) - 1;
        return n >= 0 ? this.childNodes.item(n) : null;
    }

    protected final Node getNextSibling(Node node) {
        this.checkLoaded();
        int n = this.childNodes.indexOf(node) + 1;
        return n < this.childNodes.getLength() ? this.childNodes.item(n) : null;
    }

    protected void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            if (this.data != null) {
                DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
                this.loadChildren(documentImpl.getSymbols());
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    protected final void loadChildren(SymbolTable symbolTable) throws IOException {
        int n;
        ByteArrayInput byteArrayInput = new ByteArrayInput(this.data, this.pos, this.len);
        XMLCompressedInput xMLCompressedInput = new XMLCompressedInput((InputStream)byteArrayInput, symbolTable);
        if (this.getNodeType() == 1) {
            xMLCompressedInput.readSignature();
            xMLCompressedInput.readContentSize();
            xMLCompressedInput.readShort();
            int n2 = xMLCompressedInput.readAttributeCount();
            n = 0;
            while (n < n2) {
                xMLCompressedInput.readShort();
                xMLCompressedInput.skip(xMLCompressedInput.readShort());
                ++n;
            }
        } else {
            xMLCompressedInput.readInt();
        }
        ArrayList<ElementImpl> arrayList = new ArrayList<ElementImpl>();
        n = 0;
        while (byteArrayInput.available() > 0) {
            int n3 = byteArrayInput.getPos();
            byte by = xMLCompressedInput.readSignature();
            int n4 = xMLCompressedInput.readContentSize();
            if (n4 == 0) {
                n4 = 1;
            }
            switch (xMLCompressedInput.getNodeType()) {
                case 1: {
                    ElementImpl elementImpl = new ElementImpl(this, this.data, n3, n4);
                    this.childNodes.add(elementImpl);
                    if (!elementImpl.hasAutoLink()) break;
                    n = 1;
                    arrayList.add(elementImpl);
                    break;
                }
                case 3: {
                    this.childNodes.add(new TextImpl(this, this.data, n3, n4));
                    break;
                }
                case 4: {
                    this.childNodes.add(new CDATASectionImpl(this, this.data, n3, n4));
                    break;
                }
                case 5: {
                    this.childNodes.add(new EntityReferenceImpl(this, this.data, n3, n4));
                    break;
                }
                case 6: {
                    this.childNodes.add(new EntityImpl(this, this.data, n3, n4));
                    break;
                }
                case 7: {
                    this.childNodes.add(new ProcessingInstructionImpl(this, this.data, n3, n4));
                    break;
                }
                case 8: {
                    this.childNodes.add(new CommentImpl(this, this.data, n3, n4));
                    break;
                }
                case 12: {
                    this.childNodes.add(new NotationImpl(this, this.data, n3, n4));
                }
            }
            byteArrayInput.setPos(n3);
            byteArrayInput.skip(n4);
        }
        if (n != 0) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ElementImpl elementImpl = (ElementImpl)iterator.next();
                if (!this.childNodes.contains(elementImpl)) continue;
                elementImpl.checkLoaded();
            }
        }
    }

    public final boolean hasChildNodes() {
        this.checkLoaded();
        return this.childNodes.getLength() > 0;
    }

    public final NodeList getChildNodes() {
        this.checkLoaded();
        return this.childNodes;
    }

    public final Node getFirstChild() {
        this.checkLoaded();
        if (this.childNodes.size() > 0) {
            return this.childNodes.item(0);
        }
        return null;
    }

    public final Node getLastChild() {
        this.checkLoaded();
        if (this.childNodes.size() > 0) {
            return this.childNodes.item(this.childNodes.getLength() - 1);
        }
        return null;
    }

    public final synchronized Node replaceChild(Node node, Node node2) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (!this.isNodeTypeValid(node.getNodeType())) {
            throw NodeImpl.EX_HIERARCHY_REQUEST;
        }
        int n = this.childNodes.indexOf(node2);
        if (n >= 0) {
            if (node.getNodeType() == 11) {
                this.childNodes.remove(n);
                NodeList nodeList = ((DocumentFragment)node).getChildNodes();
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    NodeImpl nodeImpl = (NodeImpl)nodeList.item(n2);
                    nodeImpl.setParentNode(this);
                    this.childNodes.add(n + n2, nodeImpl);
                    ++n2;
                }
            } else {
                NodeImpl nodeImpl = (NodeImpl)node;
                nodeImpl.setParentNode(this);
                this.childNodes.set(n, nodeImpl);
            }
        }
        this.setDirty();
        return node2;
    }

    public final synchronized Node insertBefore(Node node, Node node2) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        int n = this.childNodes.indexOf(node2);
        if (n >= 0) {
            if (!this.isNodeTypeValid(node.getNodeType())) {
                throw NodeImpl.EX_HIERARCHY_REQUEST;
            }
            if (node.getNodeType() == 11) {
                NodeList nodeList = ((DocumentFragment)node).getChildNodes();
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    NodeImpl nodeImpl = (NodeImpl)nodeList.item(n2);
                    nodeImpl.setParentNode(this);
                    this.childNodes.add(n + n2, nodeImpl);
                    ++n2;
                }
            } else {
                NodeImpl nodeImpl = (NodeImpl)node;
                nodeImpl.setParentNode(this);
                this.childNodes.add(n, nodeImpl);
            }
        }
        this.setDirty();
        return node;
    }

    public final synchronized Node removeChild(Node node) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (!((AbstractCollection)this.childNodes).remove(node)) {
            throw NodeImpl.EX_NOT_FOUND;
        }
        this.setDirty();
        return node;
    }

    public final synchronized Node appendChild(Node node) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (!this.isNodeTypeValid(node.getNodeType())) {
            throw NodeImpl.EX_HIERARCHY_REQUEST;
        }
        if (node.getNodeType() == 11) {
            NodeList nodeList = ((DocumentFragment)node).getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                NodeImpl nodeImpl = (NodeImpl)nodeList.item(n);
                nodeImpl.setParentNode(this);
                this.childNodes.add(nodeImpl);
                ++n;
            }
        } else {
            NodeImpl nodeImpl = (NodeImpl)node;
            nodeImpl.setParentNode(this);
            this.childNodes.add(nodeImpl);
        }
        this.setDirty();
        return node;
    }

    public final synchronized void normalize() {
        this.checkLoaded();
        this.checkReadOnly();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeListImpl nodeListImpl = new NodeListImpl(this);
        boolean bl = false;
        int n = this.childNodes.size();
        int n2 = 0;
        while (n2 < n) {
            Node node = null;
            Node node2 = (Node)this.childNodes.get(n2);
            short s = node2.getNodeType();
            switch (s) {
                case 3: {
                    arrayList.add(node2);
                    break;
                }
                case 1: {
                    node2.normalize();
                }
                default: {
                    node = node2;
                }
            }
            if (!(arrayList.isEmpty() || s == 3 && n2 != n - 1)) {
                Text text = (Text)arrayList.get(0);
                int n3 = arrayList.size();
                int n4 = 1;
                while (n4 < n3) {
                    bl = true;
                    Text text2 = (Text)arrayList.get(n4);
                    text.appendData(text2.getData());
                    ++n4;
                }
                nodeListImpl.add(text);
                arrayList.clear();
            }
            if (node != null) {
                nodeListImpl.add(node);
            }
            ++n2;
        }
        if (bl) {
            this.childNodes = nodeListImpl;
            this.setDirty();
        }
    }

    public final NodeList getElementsByTagName(final String string) {
        this.checkLoaded();
        NodeListImpl nodeListImpl = new NodeListImpl(this);
        NodeFilter nodeFilter = new NodeFilter(){

            public short acceptNode(Node node) {
                if (node.getNodeName().equals(string)) {
                    return 1;
                }
                return 3;
            }
        };
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)this.getOwnerDocument())).createNodeIterator(this, 1, nodeFilter, false);
        Node node = null;
        do {
            if ((node = nodeIterator.nextNode()) == null) continue;
            nodeListImpl.add(node);
        } while (node != null);
        return nodeListImpl;
    }

    public final NodeList getElementsByTagNameNS(final String string, final String string2) {
        this.checkLoaded();
        NodeListImpl nodeListImpl = new NodeListImpl(this);
        NodeFilter nodeFilter = new NodeFilter(){

            public short acceptNode(Node node) {
                if (node.getLocalName().equals(string2) && node.getNamespaceURI().equals(string)) {
                    return 1;
                }
                return 3;
            }
        };
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)this.getOwnerDocument())).createNodeIterator(this, 1, nodeFilter, false);
        Node node = null;
        do {
            if ((node = nodeIterator.nextNode()) == null) continue;
            nodeListImpl.add(node);
        } while (node != null);
        return nodeListImpl;
    }

    public final Element getElementById(String string) {
        return null;
    }
}

