/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.dom;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.XMLCompressedOutput;
import org.dbxml.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public final class DOMCompressor
extends XMLCompressedOutput {
    public DOMCompressor(OutputStream outputStream, SymbolTable symbolTable) {
        super(outputStream, symbolTable);
    }

    public void writeNode(Node node) throws IOException {
        Object object;
        if (node instanceof NodeImpl) {
            object = (NodeImpl)node;
            if (!((NodeImpl)object).dirty && ((NodeImpl)object).data != null) {
                this.write(((NodeImpl)object).data, ((NodeImpl)object).pos, ((NodeImpl)object).len);
                this.flush();
                return;
            }
        }
        switch (node.getNodeType()) {
            case 1: {
                object = node.getNamespaceURI();
                short s = object != null ? this.st.getSymbol(node.getNodeName(), (String)object, true) : this.st.getSymbol(node.getNodeName(), true);
                int n = 64;
                int n2 = node.getAttributes().getLength();
                byte by = this.getSizeType(n2);
                if (n2 > 0) {
                    n = (byte)(n | 0x20);
                }
                if (node.hasChildNodes()) {
                    n = (byte)(n | 0x10);
                }
                n = (byte)(n | (byte)by);
                byte[] byArray = this.buildChildren(node);
                int n3 = byArray.length;
                byte by2 = this.getSizeType(n3 + 11);
                n = (byte)(n | (byte)(by2 << 2));
                this.writeByte(n);
                this.writeSize(by2, n3 += this.getSizeSize(by2) + 3);
                this.writeShort(s);
                this.write(byArray);
                break;
            }
            case 2: {
                object = (Attr)node;
                String string = object.getOwnerElement().getNodeName();
                String string2 = object.getNamespaceURI();
                short s = string2 != null ? this.st.getSymbol(object.getName(), string2, true) : this.st.getSymbol(object.getName(), true);
                String string3 = object.getValue();
                this.writeShort(s);
                this.writeShort((short)string3.length());
                this.write(string3.getBytes());
                break;
            }
            case 3: {
                object = node.getNodeValue();
                int n = ((String)object).length();
                byte by = this.getSizeType(n + 5);
                byte by3 = 0;
                by3 = (byte)(by3 | (byte)(by << 2));
                this.writeByte(by3);
                this.writeSize(by, n += this.getSizeSize(by) + 1);
                this.write(((String)object).getBytes());
                break;
            }
            case 4: {
                object = node.getNodeValue();
                int n = ((String)object).length();
                int n4 = -64;
                n4 = (byte)(n4 | 0x10);
                this.writeByte(n4);
                this.writeInt(n += 5);
                this.write(((String)object).getBytes());
                break;
            }
            case 5: {
                object = node.getNodeName();
                int n = 0;
                n = (byte)(n | 0x10);
                int n5 = 0;
                int n6 = 0;
                if (((String)object).equals("&amp;")) {
                    n = (byte)(n | 2);
                } else if (((String)object).equals("&lt;")) {
                    n = (byte)(n | 3);
                } else if (((String)object).equals("&gt;")) {
                    n = (byte)(n | 4);
                } else if (((String)object).equals("&quot;")) {
                    n = (byte)(n | 5);
                } else if (((String)object).equals("&apos;")) {
                    n = (byte)(n | 6);
                } else if (((String)object).startsWith("&#x")) {
                    n6 = 1;
                    n = (byte)(n | 0x1F);
                } else {
                    n6 = 2;
                    n5 = this.st.getSymbol((String)object, true);
                    n = (byte)(n | 1);
                }
                this.writeByte(n);
                if (n6 <= 0) break;
                this.writeShort(n5);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                object = node.getNodeName() + " " + node.getNodeValue();
                int n = ((String)object).length();
                int n7 = -128;
                this.writeByte(n7);
                this.writeInt(n += 5);
                this.write(((String)object).getBytes());
                break;
            }
            case 8: {
                object = node.getNodeValue();
                int n = ((String)object).length();
                int n8 = -64;
                n8 = (byte)(n8 | 0x20);
                this.writeByte(n8);
                this.writeInt(n += 5);
                this.write(((String)object).getBytes());
                break;
            }
            case 9: {
                object = this.buildChildren(node);
                this.writeInt(((Object)object).length);
                this.write((byte[])object);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                object = this.buildChildren(node);
                this.writeInt(((Object)object).length);
                this.write((byte[])object);
                break;
            }
            case 12: {
                int n = -64;
            }
        }
        this.flush();
    }

    private byte[] buildChildren(Node node) throws IOException {
        int n;
        int n2;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream, 4096);
        DOMCompressor dOMCompressor = new DOMCompressor(bufferedOutputStream, this.st);
        if (node.getNodeType() == 1) {
            object = node.getAttributes();
            n2 = object.getLength();
            n = this.getSizeType(n2);
            dOMCompressor.writeSize(n, n2);
            int n3 = 0;
            while (n3 < n2) {
                dOMCompressor.writeNode(object.item(n3));
                ++n3;
            }
        }
        object = node.getChildNodes();
        n2 = object.getLength();
        n = 0;
        while (n < n2) {
            dOMCompressor.writeNode(object.item(n));
            ++n;
        }
        dOMCompressor.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] Compress(Node node, SymbolTable symbolTable) throws dbXMLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream, 4096);
            DOMCompressor dOMCompressor = new DOMCompressor(bufferedOutputStream, symbolTable);
            node.normalize();
            dOMCompressor.writeNode(node);
            dOMCompressor.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new dbXMLException("XML Compression Error", (Throwable)exception);
        }
    }
}

