/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.dom;

import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import org.dbxml.Debug;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.NodeSource;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.dom.AttrImpl;
import org.dbxml.xml.dom.CDATASectionImpl;
import org.dbxml.xml.dom.CommentImpl;
import org.dbxml.xml.dom.CompressedDocument;
import org.dbxml.xml.dom.ContainerNodeImpl;
import org.dbxml.xml.dom.DBDocument;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DOMImplementationImpl;
import org.dbxml.xml.dom.DocumentFragmentImpl;
import org.dbxml.xml.dom.ElementImpl;
import org.dbxml.xml.dom.EntityReferenceImpl;
import org.dbxml.xml.dom.NodeImpl;
import org.dbxml.xml.dom.ProcessingInstructionImpl;
import org.dbxml.xml.dom.TextImpl;
import org.dbxml.xml.dom.traversal.TreeWalkerImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public final class DocumentImpl
extends ContainerNodeImpl
implements CompressedDocument,
DBDocument,
DocumentTraversal {
    private DocumentType docType = null;
    private String version = null;
    private String actualEncoding = null;
    private String encoding = null;
    private boolean standalone = false;
    private boolean strictErrorChecking = false;
    private SymbolTable symbols = null;
    private boolean readOnly = false;
    private boolean authoring = false;

    public DocumentImpl() {
        super(null, true);
    }

    public DocumentImpl(byte[] byArray, int n, int n2) {
        super(null, byArray, n, n2);
    }

    public DocumentImpl(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public DocumentImpl(byte[] byArray, SymbolTable symbolTable, NodeSource nodeSource) {
        this(byArray);
        this.symbols = symbolTable;
        this.source = nodeSource;
    }

    public DocumentImpl(Document document) throws dbXMLException {
        super(null, true);
        Document document2;
        boolean bl = true;
        if (document instanceof CompressedDocument) {
            document2 = (CompressedDocument)document;
            this.symbols = document2.getSymbols();
            if (!document2.isDirty()) {
                this.data = document2.getDataBytes();
                this.pos = document2.getDataPos();
                this.len = document2.getDataLen();
                bl = false;
            }
        }
        if (bl) {
            if (this.symbols == null) {
                this.symbols = new SymbolTable();
            }
            this.data = DOMCompressor.Compress(document, this.symbols);
            this.pos = 0;
            this.len = this.data.length;
        }
        if (document instanceof DBDocument) {
            document2 = (DBDocument)document;
            this.source = document2.getSource();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            if (this.data != null) {
                this.loadChildren(this.symbols);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public boolean isCaching() {
        String string = "cache";
        int n = this.childNodes.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.childNodes.item(n2);
            if (node.getNodeType() == 7 && node.getNodeName().equals("dbxml-cache")) {
                string = node.getNodeValue().trim();
                break;
            }
            ++n2;
        }
        return string != null && string.equals("cache");
    }

    public void setCaching(boolean bl) {
        Node node;
        String string = "cache";
        int n = this.childNodes.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = this.childNodes.item(n2);
            if (node.getNodeType() == 7 && node.getNodeName().equals("dbxml-cache")) {
                node.setNodeValue(bl ? "cache" : "no-cache");
                return;
            }
            ++n2;
        }
        node = this.createProcessingInstruction("dbxml-cache", bl ? "cache" : "no-cache");
        this.insertBefore(node, this.getDocumentElement());
    }

    public boolean isAuthoring() {
        return this.authoring;
    }

    public void setAuthoring(boolean bl) {
        this.authoring = bl;
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }

    public void setSymbols(SymbolTable symbolTable) {
        this.symbols = symbolTable;
    }

    public void expandSource() {
        ElementImpl elementImpl = (ElementImpl)this.getDocumentElement();
        if (elementImpl != null) {
            elementImpl.expandSource();
        }
    }

    public Node getNodeAtPos(int n) {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public DocumentType getDoctype() {
        return this.docType;
    }

    public void setDoctype(DocumentType documentType) {
        this.docType = documentType;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getInstance();
    }

    public Text createTextNode(String string) {
        return new TextImpl((NodeImpl)this, string);
    }

    public Element getDocumentElement() {
        this.checkLoaded();
        Iterator iterator = ((AbstractList)this.childNodes).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl((NodeImpl)this, string);
    }

    public Element createElement(String string) throws DOMException {
        return new ElementImpl((NodeImpl)this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new AttrImpl((NodeImpl)this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl((NodeImpl)this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new EntityReferenceImpl((NodeImpl)this, string);
    }

    private void importNamespaces(Node node, Node node2) {
        if (node2.getNodeType() == 1) {
            HashSet<String> hashSet = new HashSet<String>();
            Node node3 = node;
            Element element = (Element)node2;
            while (node3 != null) {
                NamedNodeMap namedNodeMap = node3.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Attr attr = (Attr)namedNodeMap.item(n);
                    String string = attr.getNodeName();
                    if ((string.startsWith("xmlns:") || string.equals("xmlns")) && !hashSet.contains(string)) {
                        hashSet.add(string);
                        element.setAttribute(string, attr.getValue());
                    }
                    ++n;
                }
                if ((node3 = node3.getParentNode()).getNodeType() != 9 && node3.getNodeType() != 11) continue;
                node3 = null;
            }
        }
    }

    public Node importNode(Node node, boolean bl) {
        try {
            Object object;
            Node node2;
            Node node3;
            if (node instanceof NodeImpl && ((DocumentImpl)(node3 = (DocumentImpl)((NodeImpl)(node2 = (NodeImpl)node)).getOwnerDocument())).getSymbols() != null && ((DocumentImpl)node3).getSymbols() == this.symbols) {
                NodeImpl nodeImpl = (NodeImpl)((NodeImpl)node2).cloneNode(bl);
                nodeImpl.setParentNode(this);
                this.importNamespaces(node, nodeImpl);
                return nodeImpl;
            }
            node2 = null;
            switch (node.getNodeType()) {
                case 2: {
                    node3 = (Attr)node;
                    Attr attr = this.createAttribute(node3.getName());
                    attr.setValue(node3.getValue());
                    node2 = attr;
                    break;
                }
                case 4: {
                    node2 = this.createCDATASection(node.getNodeValue());
                    break;
                }
                case 8: {
                    node2 = this.createComment(node.getNodeValue());
                    break;
                }
                case 1: {
                    Element element = (Element)node;
                    Element element2 = this.createElement(element.getTagName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        object = (Attr)namedNodeMap.item(n2);
                        Attr attr = this.createAttribute(object.getName());
                        attr.setValue(object.getValue());
                        element2.setAttributeNode(attr);
                        ++n2;
                    }
                    node2 = element2;
                    this.importNamespaces(node, node2);
                    break;
                }
                case 5: {
                    node2 = this.createEntityReference(node.getNodeValue());
                    break;
                }
                case 7: {
                    node2 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                    break;
                }
                case 3: {
                    node2 = this.createTextNode(node.getNodeValue());
                    break;
                }
            }
            if (bl && node2 != null) {
                object = node.getChildNodes();
                int n = object.getLength();
                int n3 = 0;
                while (n3 < n) {
                    Node node4 = object.item(n3);
                    node2.appendChild(this.importNode(node4, bl));
                    ++n3;
                }
            }
            return node2;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public Element createElementNS(String string, String string2) {
        return new ElementImpl((NodeImpl)this, string2);
    }

    public Attr createAttributeNS(String string, String string2) {
        return new AttrImpl((NodeImpl)this, string2);
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return new TreeWalkerImpl(node, n, nodeFilter, bl);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return new TreeWalkerImpl(node, n, nodeFilter, bl);
    }

    public Node adoptNode(Node node) {
        return this.importNode(node, true);
    }

    public String getActualEncoding() {
        this.checkLoaded();
        return this.actualEncoding;
    }

    public void setActualEncoding(String string) {
        this.checkReadOnly();
        this.checkLoaded();
        this.actualEncoding = string;
    }

    public String getEncoding() {
        this.checkLoaded();
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.checkReadOnly();
        this.checkLoaded();
        this.encoding = string;
    }

    public String getVersion() {
        this.checkLoaded();
        return this.version;
    }

    public void setVersion(String string) {
        this.checkReadOnly();
        this.checkLoaded();
        this.version = string;
    }

    public boolean getStandalone() {
        this.checkLoaded();
        return this.standalone;
    }

    public void setStandalone(boolean bl) {
        this.checkReadOnly();
        this.checkLoaded();
        this.standalone = bl;
    }

    public boolean getStrictErrorChecking() {
        this.checkLoaded();
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.checkReadOnly();
        this.checkLoaded();
        this.strictErrorChecking = bl;
    }
}

