/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.Properties;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.data.Key;
import org.dbxml.core.objects.MapArgs;
import org.dbxml.core.objects.Reflectable;
import org.dbxml.core.objects.Reflector;
import org.dbxml.core.objects.Variant;
import org.dbxml.core.objects.XMLObject;
import org.dbxml.core.request.URIMapper;
import org.dbxml.server.util.ByteArrayInput;
import org.dbxml.xml.NodeSource;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.XMLCompressedInput;
import org.dbxml.xml.dom.AttrImpl;
import org.dbxml.xml.dom.ContainerNodeImpl;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.dom.NamedNodeMapImpl;
import org.dbxml.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ElementImpl
extends ContainerNodeImpl
implements Element {
    private static final String SRC_NS = "xmlns:src";
    private static final String SRC_COL = "src:col";
    private static final String SRC_KEY = "src:key";
    private NamedNodeMapImpl attributes = new NamedNodeMapImpl(this);
    private boolean hasAuto = false;
    private short symbolID = (short)-1;

    public ElementImpl() {
    }

    public ElementImpl(NodeImpl nodeImpl, byte[] byArray, int n, int n2) {
        super(nodeImpl, byArray, n, n2);
        DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
        try {
            this.loadAttributes(documentImpl.getSymbols());
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public ElementImpl(NodeImpl nodeImpl, boolean bl) {
        super(nodeImpl, bl);
    }

    public ElementImpl(NodeImpl nodeImpl, String string) {
        super(nodeImpl, true);
        this.nodeName = string;
    }

    protected boolean isNodeTypeValid(short s) {
        return s == 1 || s == 8 || s == 3 || s == 4 || s == 5;
    }

    public boolean hasAutoLink() {
        return this.hasAuto;
    }

    protected void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            if (this.data != null) {
                DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
                SymbolTable symbolTable = documentImpl.getSymbols();
                ByteArrayInput byteArrayInput = new ByteArrayInput(this.data, this.pos, this.len);
                XMLCompressedInput xMLCompressedInput = new XMLCompressedInput((InputStream)byteArrayInput, symbolTable);
                xMLCompressedInput.readSignature();
                xMLCompressedInput.readContentSize();
                this.symbolID = xMLCompressedInput.readShort();
                SymbolTable.SymbolInfo symbolInfo = symbolTable.getSymbolInfo(this.symbolID);
                this.nodeName = symbolInfo.getQName();
                this.nsURI = symbolInfo.getNamespaceURI();
                this.loadChildren(symbolTable);
                if (this.hasAuto && !documentImpl.isAuthoring()) {
                    this.autoLink();
                }
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public short getSymbolID() {
        return this.symbolID;
    }

    public void expandSource() {
        NodeSource nodeSource = this.getSource();
        if (nodeSource != null) {
            this.setAttribute(SRC_NS, "http://www.dbxml.org/Query");
            this.setAttribute(SRC_COL, nodeSource.getCollection().getCanonicalName());
            Key key = nodeSource.getKey();
            if (key != null) {
                this.setAttribute(SRC_KEY, key.toString());
            }
        }
    }

    protected void loadAttributes(SymbolTable symbolTable) throws IOException {
        ByteArrayInput byteArrayInput = new ByteArrayInput(this.data, this.pos, this.len);
        XMLCompressedInput xMLCompressedInput = new XMLCompressedInput((InputStream)byteArrayInput, symbolTable);
        xMLCompressedInput.readSignature();
        xMLCompressedInput.readContentSize();
        short s = xMLCompressedInput.readShort();
        int n = xMLCompressedInput.readAttributeCount();
        int n2 = 0;
        while (n2 < n) {
            short s2 = xMLCompressedInput.readShort();
            short s3 = xMLCompressedInput.readShort();
            byte[] byArray = new byte[s3];
            xMLCompressedInput.read(byArray);
            SymbolTable.SymbolInfo symbolInfo = symbolTable.getSymbolInfo(s2);
            String string = symbolInfo.getQName();
            String string2 = symbolInfo.getNamespaceURI();
            AttrImpl attrImpl = new AttrImpl(this, string, string2, s2, new String(byArray));
            this.attributes.setNamedItem(attrImpl);
            if (!this.hasAuto && string.endsWith("href")) {
                this.hasAuto = true;
            }
            ++n2;
        }
    }

    private void autoLink() {
        String string = this.getAttributeNS("http://www.dbxml.org/XMLObject", "href");
        if (string != null && string.length() > 0) {
            DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
            SymbolTable symbolTable = documentImpl.getSymbols();
            Collection collection = null;
            NodeSource nodeSource = documentImpl.getSource();
            if (nodeSource != null) {
                collection = nodeSource.getCollection();
            }
            if (string.indexOf("://") == -1 && !string.startsWith("/")) {
                string = this.getSource().getCanonicalName() + '/' + string;
            }
            if (collection != null) {
                String string2 = this.getAttributeNS("http://www.dbxml.org/XMLObject", "type");
                if (string2 == null || string2.length() == 0) {
                    string2 = "replace";
                }
                URIMapper uRIMapper = null;
                try {
                    uRIMapper = collection.getDatabase().getURIMapper(string);
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
                Node node = null;
                switch (uRIMapper.getObjectType()) {
                    case 3: {
                        node = documentImpl.importNode(uRIMapper.getDocument().getDocumentElement(), true);
                        break;
                    }
                    case 4: {
                        XMLObject xMLObject = uRIMapper.getXMLObject();
                        String string3 = uRIMapper.getMethod();
                        Reflector reflector = xMLObject.getReflector();
                        Object object = null;
                        Properties properties = uRIMapper.getProperties();
                        Object[] objectArray = uRIMapper.getArguments();
                        try {
                            object = properties != null ? reflector.invoke((Reflectable)xMLObject, string3, new MapArgs(properties)) : (objectArray != null ? reflector.invoke((Reflectable)xMLObject, string3, objectArray) : reflector.invoke((Reflectable)xMLObject, string3, this));
                        }
                        catch (Exception exception) {
                            Debug.printStackTrace((Throwable)exception);
                        }
                        if (object == null) break;
                        node = object instanceof Document ? documentImpl.importNode(((Document)object).getDocumentElement(), true) : (object instanceof Node ? documentImpl.importNode((Node)object, true) : documentImpl.createTextNode(new Variant(object).toString()));
                    }
                }
                uRIMapper.reclaim();
                if (node != null) {
                    NodeImpl nodeImpl = (NodeImpl)node;
                    try {
                        if (string2.equals("replace")) {
                            this.parentNode.replaceChild(nodeImpl, this);
                        } else if (string2.equals("content")) {
                            this.childNodes.clear();
                            this.childNodes.add(nodeImpl);
                            nodeImpl.setParentNode(this);
                        } else if (string2.equals("append")) {
                            this.childNodes.add(nodeImpl);
                            nodeImpl.setParentNode(this);
                        } else if (string2.equals("insert")) {
                            this.childNodes.add(0, nodeImpl);
                            nodeImpl.setParentNode(this);
                        }
                    }
                    catch (Exception exception) {
                        Debug.println((Object)this, (Object)exception);
                    }
                }
            }
        }
    }

    public short getNodeType() {
        return 1;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public boolean hasAttribute(String string) {
        return this.attributes.getNamedItem(string) != null;
    }

    public void removeAttribute(String string) throws DOMException {
        this.checkReadOnly();
        AttrImpl attrImpl = (AttrImpl)this.attributes.removeNamedItem(string);
        attrImpl.setParentNode((NodeImpl)((Object)this.getOwnerDocument()));
        this.setDirty();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String string) {
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        return attr != null ? attr.getValue() : "";
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.checkReadOnly();
        Attr attr2 = (Attr)this.attributes.getNamedItem(attr.getName());
        DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
        if (attr.getParentNode().getNodeType() == 1) {
            throw NodeImpl.EX_INUSE_ATTRIBUTE;
        }
        if (documentImpl != attr.getOwnerDocument()) {
            throw NodeImpl.EX_WRONG_DOCUMENT;
        }
        ((AttrImpl)attr).setParentNode(this);
        this.attributes.setNamedItem(attr);
        this.setDirty();
        return attr2;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        Attr attr = this.getOwnerDocument().createAttribute(string);
        attr.setValue(string2);
        this.setAttributeNode(attr);
    }

    public Attr getAttributeNode(String string) {
        return (Attr)this.attributes.getNamedItem(string);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.checkReadOnly();
        DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
        if (attr.getParentNode() != this) {
            throw NodeImpl.EX_NOT_FOUND;
        }
        ((AbstractCollection)this.attributes).remove(attr.getName());
        ((AttrImpl)attr).setParentNode((NodeImpl)((Object)this.getOwnerDocument()));
        this.setDirty();
        return attr;
    }

    public String getAttributeNS(String string, String string2) {
        Attr attr = (Attr)this.attributes.getNamedItemNS(string, string2);
        return attr != null ? attr.getValue() : null;
    }

    public void setAttributeNS(String string, String string2, String string3) {
        Attr attr = this.getOwnerDocument().createAttributeNS(string, string2);
        attr.setValue(string3);
        this.setAttributeNodeNS(attr);
    }

    public void removeAttributeNS(String string, String string2) {
        this.checkReadOnly();
        this.attributes.removeNamedItemNS(string, string2);
        this.setDirty();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) {
        return this.setAttributeNode(attr);
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.attributes.getNamedItemNS(string, string2) != null;
    }
}

