/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.dom;

import java.util.HashMap;
import org.dbxml.xml.NodeSource;
import org.dbxml.xml.dom.AttrImpl;
import org.dbxml.xml.dom.CDATASectionImpl;
import org.dbxml.xml.dom.CommentImpl;
import org.dbxml.xml.dom.CompressedNode;
import org.dbxml.xml.dom.DBNode;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DOMImplementationImpl;
import org.dbxml.xml.dom.DocumentFragmentImpl;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.dom.ElementImpl;
import org.dbxml.xml.dom.EntityReferenceImpl;
import org.dbxml.xml.dom.NodeListImpl;
import org.dbxml.xml.dom.NotationImpl;
import org.dbxml.xml.dom.ProcessingInstructionImpl;
import org.dbxml.xml.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
implements CompressedNode,
DBNode {
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String OBJECT_NS = "http://www.dbxml.org/XMLObject";
    public static final String OBJECT_HREF = "href";
    public static final String OBJECT_TYPE = "type";
    public static final String TYPE_CONTENT = "content";
    public static final String TYPE_REPLACE = "replace";
    public static final String TYPE_INSERT = "insert";
    public static final String TYPE_APPEND = "append";
    public static final DOMException EX_NO_MODIFICATION_ALLOWED = new DOMException(7, "This Node Is Read-Only");
    public static final DOMException EX_INUSE_ATTRIBUTE = new DOMException(10, "This Attribute Belongs To Another Element");
    public static final DOMException EX_WRONG_DOCUMENT = new DOMException(4, "This Attribute Belongs To Another Document");
    public static final DOMException EX_NOT_FOUND = new DOMException(8, "This Node Does Not Belong To This Element");
    public static final DOMException EX_HIERARCHY_REQUEST = new DOMException(3, "This Node Cannot Contain This Child");
    public static final DOMException EX_NO_DATA_ALLOWED = new DOMException(6, "This Node Has No Value");
    public static final DOMException EX_INVALID_STATE = new DOMException(11, "NodeIterator Has Been Detached");
    public static final DOMException EX_DOMSTRING_SIZE = new DOMException(2, "String Too Large For Type");
    public static final DOMException EX_INDEX_SIZE = new DOMException(1, "Index Out Of Bounds");
    protected NodeSource source = null;
    protected byte[] data = null;
    protected int pos = 0;
    protected int len = 0;
    protected boolean loaded = false;
    protected boolean dirty = false;
    protected NodeImpl parentNode = null;
    protected String nodeName = null;
    protected String nodeValue = null;
    protected String nsURI = null;
    protected HashMap userData = null;
    protected Object key = null;

    public NodeImpl() {
    }

    public NodeImpl(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.pos = n;
        this.len = n2;
    }

    public NodeImpl(NodeImpl nodeImpl, byte[] byArray, int n, int n2) {
        this(byArray, n, n2);
        this.parentNode = nodeImpl;
    }

    public NodeImpl(NodeImpl nodeImpl, boolean bl) {
        this.parentNode = nodeImpl;
        if (bl) {
            this.setDirty();
        }
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    protected void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
    }

    public void load() {
        this.checkLoaded();
    }

    public void unload() {
        if (this.loaded) {
            this.loaded = false;
        }
    }

    public short getSymbolID() {
        return -1;
    }

    public final void checkReadOnly() throws DOMException {
        DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
        if (documentImpl != null && documentImpl.isReadOnly()) {
            throw EX_NO_MODIFICATION_ALLOWED;
        }
    }

    public final boolean isDefined() {
        return this.data != null;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty() {
        this.dirty = true;
        if (this.parentNode != null) {
            this.parentNode.setDirty();
        }
    }

    public byte[] getDataBytes() {
        return this.data;
    }

    public void setDataBytes(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.pos = n;
        this.len = n2;
    }

    public void setDataBytes(byte[] byArray) {
        this.data = byArray;
    }

    public int getDataPos() {
        return this.pos;
    }

    public void setDataPos(int n) {
        this.pos = n;
    }

    public int getDataLen() {
        return this.len;
    }

    public void setDataLen(int n) {
        this.len = n;
    }

    public final void setNodeName(String string) {
        this.checkLoaded();
        this.nodeName = string;
        this.setDirty();
    }

    public final void setParentNode(NodeImpl nodeImpl) {
        this.parentNode = nodeImpl;
    }

    protected Node getPreviousSibling(Node node) {
        return null;
    }

    protected Node getNextSibling(Node node) {
        return null;
    }

    public final void setSource(NodeSource nodeSource) {
        this.source = nodeSource;
    }

    public final NodeSource getSource() {
        if (this.source == null && this.parentNode != null) {
            return this.parentNode.getSource();
        }
        return this.source;
    }

    public void expandSource() {
    }

    public abstract short getNodeType();

    public Node getLastChild() {
        return null;
    }

    public final Node getPreviousSibling() {
        return this.parentNode != null ? this.parentNode.getPreviousSibling(this) : null;
    }

    public final Node getNextSibling() {
        return this.parentNode != null ? this.parentNode.getNextSibling(this) : null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public final Document getOwnerDocument() {
        if (this.getNodeType() == 9) {
            return (Document)((Object)this);
        }
        return this.parentNode != null ? this.parentNode.getOwnerDocument() : null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw EX_HIERARCHY_REQUEST;
    }

    public NodeList getChildNodes() {
        return new NodeListImpl(this);
    }

    public void setNodeValue(String string) throws DOMException {
        throw EX_NO_DATA_ALLOWED;
    }

    public final Node getParentNode() {
        return this.parentNode;
    }

    public Node getFirstChild() {
        return null;
    }

    public String getNodeName() {
        this.checkLoaded();
        return this.nodeName;
    }

    public String getNodeValue() throws DOMException {
        this.checkLoaded();
        return this.nodeValue;
    }

    public synchronized Node replaceChild(Node node, Node node2) throws DOMException {
        throw EX_HIERARCHY_REQUEST;
    }

    public synchronized Node removeChild(Node node) throws DOMException {
        throw EX_NOT_FOUND;
    }

    public synchronized Node appendChild(Node node) throws DOMException {
        throw EX_HIERARCHY_REQUEST;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public final synchronized Node cloneNode(boolean bl) {
        Object object;
        Object object2;
        DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
        if (bl) {
            object2 = this.data;
            int n = this.pos;
            int n2 = this.len;
            if (this.dirty) {
                try {
                    object2 = DOMCompressor.Compress(this, documentImpl.getSymbols());
                    n = 0;
                    n2 = ((byte[])object2).length;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            NodeImpl nodeImpl = null;
            switch (this.getNodeType()) {
                case 2: {
                    nodeImpl = new AttrImpl(this, true);
                    nodeImpl.setNodeName(this.getNodeName());
                    nodeImpl.setNodeValue(this.getNodeValue());
                    break;
                }
                case 4: {
                    nodeImpl = new CDATASectionImpl(this, (byte[])object2, n, n2);
                    break;
                }
                case 8: {
                    nodeImpl = new CommentImpl(this, (byte[])object2, n, n2);
                    break;
                }
                case 11: {
                    DocumentFragmentImpl documentFragmentImpl = new DocumentFragmentImpl(this);
                    if (bl) {
                        object = this.getChildNodes();
                        int n3 = 0;
                        while (n3 < object.getLength()) {
                            documentFragmentImpl.appendChild(object.item(n3).cloneNode(bl));
                            ++n3;
                        }
                    }
                    nodeImpl = documentFragmentImpl;
                    break;
                }
                case 1: {
                    nodeImpl = new ElementImpl(this, (byte[])object2, n, n2);
                    break;
                }
                case 5: {
                    nodeImpl = new EntityReferenceImpl(this, (byte[])object2, n, n2);
                    break;
                }
                case 12: {
                    nodeImpl = new NotationImpl(this, (byte[])object2, n, n2);
                    break;
                }
                case 7: {
                    nodeImpl = new ProcessingInstructionImpl(this, (byte[])object2, n, n2);
                    break;
                }
                case 3: {
                    nodeImpl = new TextImpl(this, (byte[])object2, n, n2);
                }
            }
            if (nodeImpl != null) {
                return nodeImpl;
            }
        }
        this.checkLoaded();
        switch (this.getNodeType()) {
            case 2: {
                object2 = documentImpl.createAttribute(this.nodeName);
                object2.setValue(this.nodeValue);
                return object2;
            }
            case 4: {
                return documentImpl.createCDATASection(this.nodeValue);
            }
            case 8: {
                return documentImpl.createComment(this.nodeValue);
            }
            case 11: {
                return documentImpl.createDocumentFragment();
            }
            case 1: {
                Element element = documentImpl.createElement(this.nodeName);
                NamedNodeMap namedNodeMap = this.getAttributes();
                int n = namedNodeMap.getLength();
                int n4 = 0;
                while (n4 < n) {
                    object = (Attr)namedNodeMap.item(n4);
                    element.setAttribute(object.getName(), object.getValue());
                    ++n4;
                }
                return element;
            }
            case 5: {
                return documentImpl.createEntityReference(this.nodeValue);
            }
            case 7: {
                return documentImpl.createProcessingInstruction(this.nodeName, this.nodeValue);
            }
            case 3: {
                return documentImpl.createTextNode(this.nodeValue);
            }
        }
        return null;
    }

    public void normalize() {
    }

    public final boolean isSupported(String string, String string2) {
        return DOMImplementationImpl.HasFeature(string, string2);
    }

    public final String getNamespaceURI() {
        if (this.nsURI != null) {
            return this.nsURI;
        }
        short s = this.getNodeType();
        if (s != 1 && s != 2) {
            return null;
        }
        String string = this.getPrefix();
        return string != null ? this.lookupNamespaceURI(string) : this.lookupDefaultNamespaceURI();
    }

    public final String getPrefix() {
        short s = this.getNodeType();
        if (s != 1 && s != 2) {
            return null;
        }
        this.checkLoaded();
        int n = this.nodeName.indexOf(58);
        return n != -1 ? this.nodeName.substring(0, n) : null;
    }

    public final void setPrefix(String string) {
        short s = this.getNodeType();
        if (s != 1 && s != 2) {
            return;
        }
        this.checkReadOnly();
        String string2 = this.getLocalName();
        if (string != null) {
            this.setNodeName(string + ':' + string2);
        } else {
            this.setNodeName(string2);
        }
    }

    public final String getLocalName() {
        short s = this.getNodeType();
        if (s != 1 && s != 2) {
            return null;
        }
        String string = this.getPrefix();
        return string != null ? this.getNodeName().substring(string.length() + 1) : this.getNodeName();
    }

    public final String lookupDefaultNamespaceURI() {
        String string = null;
        if (this.getNodeType() == 1) {
            string = ((Element)((Object)this)).getAttribute(XMLNS_PREFIX);
        }
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.parentNode != null ? this.parentNode.lookupDefaultNamespaceURI() : null;
    }

    public final boolean isSameNode(Node node) {
        return this == node;
    }

    public final String lookupNamespacePrefix(String string) {
        if (this.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string2 = attr.getName();
                if (string2.startsWith("xmlns:") && attr.getValue().equals(string)) {
                    return string2.substring(XMLNS_PREFIX.length() + 1);
                }
                ++n2;
            }
        }
        return this.parentNode != null ? this.parentNode.lookupNamespacePrefix(string) : null;
    }

    public final String lookupNamespaceURI(String string) {
        String string2 = null;
        if (this.getNodeType() == 1) {
            string2 = ((Element)((Object)this)).getAttribute("xmlns:" + string);
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return this.parentNode != null ? this.parentNode.lookupNamespaceURI(string) : null;
    }

    public void normalizeNS() throws DOMException {
    }

    public final synchronized Object setUserData(Object object, String string) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        Object v = this.userData.get(string);
        this.userData.put(string, object);
        return v;
    }

    public final synchronized Object getUserData(String string) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(string);
    }

    public final synchronized Object getKey() {
        if (this.key == null) {
            this.key = new Object();
        }
        return this.key;
    }
}

