/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbxml.Debug;
import org.dbxml.server.util.ByteArrayInput;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.XMLCompressedInput;
import org.dbxml.xml.dom.CompressedDocument;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.sax.CompressionHandler;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXEventGenerator
implements XMLReader {
    private SymbolTable symbols = null;
    private byte[] data = null;
    private int pos = 0;
    private int len = 0;
    private List features = new ArrayList();
    private Map properties = new HashMap();
    private ContentHandler content = null;
    private LexicalHandler lexical = null;
    private CompressionHandler comp = null;
    private ErrorHandler errors = null;
    private EntityResolver entities = null;
    private DTDHandler dtd = null;
    private boolean interrupt = false;

    public SAXEventGenerator(SymbolTable symbolTable, byte[] byArray) {
        this.symbols = symbolTable;
        this.data = byArray;
        this.len = byArray.length;
    }

    public SAXEventGenerator(SymbolTable symbolTable, byte[] byArray, int n, int n2) {
        this.symbols = symbolTable;
        this.data = byArray;
        this.pos = n;
        this.len = n2;
    }

    public SAXEventGenerator(Document document) {
        try {
            if (document instanceof CompressedDocument) {
                document = new DocumentImpl(document);
                CompressedDocument compressedDocument = (CompressedDocument)document;
                this.symbols = compressedDocument.getSymbols();
                this.data = compressedDocument.getDataBytes();
                this.pos = compressedDocument.getDataPos();
                this.len = compressedDocument.getDataLen();
            } else {
                this.symbols = new SymbolTable();
                this.data = DOMCompressor.Compress(document, this.symbols);
                this.len = this.data.length;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.properties.put(string, object);
        if (string.equals("CompressionHandler/1.0") && object instanceof CompressionHandler) {
            this.comp = (CompressionHandler)object;
        }
        if (string.equals("http://xml.org/sax/properties/lexical-handler") && object instanceof LexicalHandler) {
            this.lexical = (LexicalHandler)object;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entities = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entities;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtd = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtd;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.content = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.content;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errors = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errors;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
    }

    public void parse(String string) throws IOException, SAXException {
    }

    private final String getLocalName(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public boolean processContainer(boolean bl, int n, int n2) throws IOException, SAXException {
        Object object;
        Object object2;
        Object object3;
        short s;
        ByteArrayInput byteArrayInput = new ByteArrayInput(this.data, n, n2);
        XMLCompressedInput xMLCompressedInput = new XMLCompressedInput((InputStream)byteArrayInput, this.symbols);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (bl) {
            xMLCompressedInput.readSignature();
            xMLCompressedInput.readContentSize();
            s = xMLCompressedInput.readShort();
            string = this.symbols.getName(s);
            string2 = this.getLocalName(string);
            string3 = this.symbols.getNamespaceURI(s);
            int n3 = xMLCompressedInput.readAttributeCount();
            AttributesImpl attributesImpl = new AttributesImpl();
            int n4 = 0;
            while (n4 < n3) {
                short s2 = xMLCompressedInput.readShort();
                short s3 = xMLCompressedInput.readShort();
                object3 = new byte[s3];
                xMLCompressedInput.read((byte[])object3);
                object2 = this.symbols.getName(s2);
                String string4 = this.symbols.getNamespaceURI(s2);
                object = this.getLocalName((String)object2);
                attributesImpl.addAttribute(string4 != null ? string4 : "", (String)object, (String)object2, "", new String((byte[])object3));
                ++n4;
            }
            if (this.comp != null) {
                this.comp.symbolID(s);
                this.comp.dataLocation(n, n2);
            }
            this.content.startElement(string3 != null ? string3 : "", string2, string, attributesImpl);
        } else {
            xMLCompressedInput.readInt();
        }
        while (!this.interrupt && byteArrayInput.available() > 0) {
            n = byteArrayInput.getPos();
            s = xMLCompressedInput.readSignature();
            n2 = xMLCompressedInput.readContentSize();
            if (n2 == 0) {
                n2 = 1;
            }
            Object var10_11 = null;
            short s4 = xMLCompressedInput.getNodeType();
            switch (s4) {
                case 1: {
                    this.processContainer(true, n, n2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    ByteArrayInput byteArrayInput2 = new ByteArrayInput(this.data, n, n2);
                    XMLCompressedInput xMLCompressedInput2 = new XMLCompressedInput((InputStream)byteArrayInput2, this.symbols);
                    xMLCompressedInput2.readSignature();
                    if (s4 == 3) {
                        xMLCompressedInput2.readContentSize();
                    } else {
                        xMLCompressedInput2.readInt();
                    }
                    byte[] byArray = new byte[byteArrayInput2.available()];
                    xMLCompressedInput2.read(byArray);
                    object3 = new String(byArray);
                    switch (s4) {
                        case 3: {
                            object2 = ((String)object3).toCharArray();
                            this.content.characters((char[])object2, 0, ((Object)object2).length);
                            break;
                        }
                        case 7: {
                            int n5 = ((String)object3).indexOf(32);
                            this.content.processingInstruction(((String)object3).substring(0, n5), ((String)object3).substring(n5 + 1));
                            break;
                        }
                        case 4: {
                            if (this.lexical == null) break;
                            this.lexical.startCDATA();
                            object = ((String)object3).toCharArray();
                            this.content.characters((char[])object, 0, ((Object)object).length);
                            this.lexical.endCDATA();
                            break;
                        }
                        case 8: {
                            if (this.lexical == null) break;
                            object = ((String)object3).toCharArray();
                            this.lexical.comment((char[])object, 0, ((Object)object).length);
                        }
                    }
                    break;
                }
                case 5: {
                    break;
                }
            }
            byteArrayInput.setPos(n);
            byteArrayInput.skip(n2);
        }
        if (bl && !this.interrupt) {
            this.content.endElement(string3 != null ? string3 : "", string2, string);
        }
        return !this.interrupt;
    }

    public boolean processDocument() throws IOException, SAXException {
        if (this.comp != null) {
            this.comp.symbols(this.symbols);
            this.comp.dataBytes(this.data);
        }
        this.content.startDocument();
        boolean bl = this.processContainer(false, this.pos, this.len);
        if (bl) {
            this.content.endDocument();
        }
        return bl;
    }

    public boolean start() {
        try {
            return this.processDocument();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public void stop() {
        this.interrupt = true;
    }
}

