/**
 * =====================================================================================
 *
 *       Filename:  main.c
 *
 *    Description:  
 *
 *        Version:  1.0
 *        Created:  04/07/11 09:28:13
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Emanuele Placidi (zad), emanuele.placidi@gmail.com
 *        Company:  
 *
 * =====================================================================================
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <error.h>
#include <errno.h>
#include <locale.h>
#include <locale.h>
#include <langinfo.h>
#include <string.h>
#include <ftw.h>
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
/** UTILS */
#define DEBUG(args...)  printf("%s:",__func__);printf(args)
/* The error path is capture in the log file */
#define ERROR(args...)  printf("%sE[L%d]:",__func__,__LINE__);printf(args)
#define ERRORS(err,args...)  error_at_line(0,err,__FILE__,__LINE__,"%s E:",__func__);printf(args)

/** Functions declaration */

int getNumHex(char *par, char *str, unsigned int lim);
int getNum(char *par, char *str, unsigned int lim);
long long int getNumArg(char *par);
int mask_params(unsigned int mask,int *sizeP,int *offsetP);
int file_exists(const char * filename);int file_exists(const char * filename)
{
  FILE * file=NULL;
  file= fopen(filename, "r");
  if (file!=NULL)
  {
    fclose(file);
    return 0;
  }
  return -1;
}


int getNumHex(char *par, char *str, unsigned int lim)
{
  int val;

  if( (!par) || (sscanf(par, "%x", &val) != 1) || (val>lim) || (val<0) )
  {
    printf("Invalid %s\n", str);
    return 0;
  }
  return( val );
}
int getNum(char *par, char *str, unsigned int lim)
{
  unsigned int val = 0;
  if(lim<=0){
    lim=0xffffffff;
  }
  if(strcmp("0x",par)>0){
    return getNumHex(par,str,lim);
  }
  if (!par || sscanf(par, "%i", &val) != 1 || val > lim || val < 0) {
    printf("Invalid %s\n", str);
    return 0;
  }

  return val;
}
long long int getNumArg(char *par)
{
  long long int i= strtoll(par,NULL,0);
  if(errno==ERANGE){
    printf("Invalid number%s\n", par);
    i=0;
  }
  return i;
}
/** END UTILS */
/** XML UTILS */

/**
 * =====================================================================================
 *@fn xmlChar * get_attribute_val(xmlNodePtr element,char * attribute_name)
 *         @brief Extracts the value of the attribute named attribute_name from
 *         the passed node pointer element
 *         @param element an xmlNodePtr wher to look for the attribute
 *         @param attribute_name a char pointer containig the searched attrbute
 *         name
 *         @return an cmlChar pointer is returned. NOTE: Returned pointer must
 *         be freed by the caller with xmlFree()
 * =====================================================================================
 */
xmlChar * get_attribute_val(xmlNodePtr element,char * attribute_name)
{
  xmlChar *res=NULL;
  if(element==NULL || attribute_name==NULL){
    ERRORS(EINVAL,"null pointer attribute passed\nelement=%p\nattribute_name=%p",
        element,attribute_name);
    return NULL;
  }
  res=xmlGetProp(element,(xmlChar *)attribute_name);
  //DEBUG("-----Param[%s] value-----\n%s\n----------------------",attribute_name,res);
  return res;
}
/**
 * =====================================================================================
 *@fn xmlXPathObjectPtr get_xml_elements(xmlNodePtr nodePtr,char *elementName)
 *         @brief this function looks for elements named elementName in the
 *         document passed.
 *         @param nodePtr a  xmlNodePtr where to look for element named
 *         elementName
 *         @param elementName char pointer used as search key  
 *         @return xmlXPathObjectPtr containing one or more element named
 *         elementName. NOTE: Returned pointer must be freed by the caller with
 *         xmlXPathFreeObject()
 * =====================================================================================
 */
xmlXPathObjectPtr get_xml_elements(xmlNodePtr nodePtr,char *elementName)
{
  xmlXPathContextPtr context=NULL;
  xmlXPathObjectPtr result=NULL;
  xmlChar * lookup=NULL;
  int extraSpace=strlen("child::");
  /** check parameters */
  if(nodePtr==NULL || elementName == NULL){
    ERRORS(EINVAL,"null pointer param passed\nnodePtr=%p,elementName=%p",nodePtr,elementName);
    return NULL;
  }

  /** xmlXPathNewContext allocs a xmlXPathContextPtr */
  context = xmlXPathNewContext(nodePtr->doc);
  if(context==NULL){
    ERRORS(ENOMEM,"xmlXPathNewContext fails\n");
    return NULL;
  }
  /** configure node, the current node, to the one passed in the arg */
  context->node=nodePtr;

  /** resize lookup of extraspace+1 :1 for \0 and extraspace for axis */
  lookup=calloc(strlen(elementName)+extraSpace+1,sizeof(xmlChar));
  if(lookup==NULL){
    ERRORS(ENOMEM,"Error allocating space for alloc new string child::%s\n",elementName);
    return NULL;
  }
  strcat((char *)lookup,"child::");
  strcat((char *)lookup,elementName);
  result = xmlXPathEvalExpression(lookup,context);
  free(lookup);
  xmlXPathFreeContext(context);
  if(result == NULL){
    ERROR("error in xmlXPathEvalExpression\n");
    return NULL;
  }
  if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
    xmlXPathFreeObject(result);
    ERROR("No Element %s found\n",elementName);
    //print_element_names((xmlNodePtr)nodePtr);
    return NULL;
  }
  return result;
}

/**
 * =====================================================================================
 *@fn xmlNodePtr xml_root(const char* file)
 *         @brief takes a path to an xml file, check if it exists (file_exist()
 *         utils.h ) than reads the file,create an xmlDoc and returns a
 *         xmlNodePtr which points to the root of the xml file.
 *         @param file a pointer to char containing the path to the file
 *         @return a xmlNodePtr which points to the root node of the xmlDoc
 *         NULL is returned in case of failure;
 *         NOTE: xmlDoc must be freed after the use (end of main program) to
 *         free it: 
 *         xmlDoc * doc= returnedXmlNodePtr->doc;
 *         xmlFreeDoc(doc);
 *         xmlCleanupParser();
 *
 * =====================================================================================
 */
xmlNodePtr xml_root(char* file)
{
  xmlDoc *doc = NULL;
  xmlNodePtr root_element = NULL;
  if(file==NULL){
    ERROR("conf_file is NULL\n");
    return NULL;
  }
  if(file_exists(file)){
    ERROR("%s doesn't exist\n",file);
    return NULL;
  }
  /*parse the file and get the DOM */
  doc = xmlReadFile(file, NULL, 0);

  if (doc == NULL) {
    ERROR("could not parse file %s\n", file);
    return NULL;
  }

  /*Get the root element node */
  root_element = xmlDocGetRootElement(doc);
  return root_element;
}
/** XML UTILS END */
/**  Structs Defs*/
struct field_desc{
  /** name is an xmlChar * and meust be freed using xmlXfree() */
    unsigned int mask;
  xmlChar * name;
  unsigned int def_val;
  unsigned int offset;
};

struct register_desc {
  xmlChar* name;
  int size;
  unsigned int offset;
  struct field_desc **fields;
};

/** End Structs Defs */
char * progName;
void usage(FILE *stream,int exit_code) 
{
  fprintf(stream, "Usage %s -f xmlfile \n",progName);
  fprintf(stream, 
      "  -f --file xmlFilePath       xmlto use\n"
      );
  exit (exit_code);

}
void parse_registers(xmlNodePtr root);
char *confname=NULL;
int main (int argc, char *argv[] )
{
  /*  A string listing valid short options letters*/
  char *file_name=NULL;
  xmlNodePtr root_element=NULL;
  const char* const short_options = "hf:";
  const struct option long_option[]={
    {"help",0,NULL,'h'},
    {"file",0,NULL,'f'},
    {0,0,0,0}
  };

  progName = argv[0];
  int next_opt=0;
  do{
    next_opt=getopt_long(argc,argv,short_options,long_option,NULL);
    switch(next_opt){
      case 'h':
        usage(stdout,0);
        break;
      case 'f':
        file_name=optarg;
        break;
      default:
        break;
    }
  }while(next_opt!=-1);
  if(file_name==NULL){
    usage(stdout,0);
  }
  if(file_exists(file_name)){
	ERRORS(EINVAL,"conf file not found\n");
	return 0;
  }
  DEBUG("passing to parse_conf_file %p\n",file_name);
  if((root_element=xml_root(file_name))==NULL){
	ERRORS(EINVAL,"failure parsing file %s\n",file_name); 
	return 0;
  }
  //print_element_names(root_element);
  parse_registers(root_element);
  xmlDoc * doc= root_element->doc;
  xmlFreeDoc(doc);
  xmlCleanupParser();
  return 0;
}
struct field_desc** parse_register_field(xmlNodePtr root){
  xmlChar * tempC=NULL;
  xmlNodeSetPtr field_set=NULL;
  xmlXPathObjectPtr xmlPathP=NULL;
  int index=0;
  struct field_desc** fields=NULL;
  if(root==NULL){
    ERRORS(EINVAL,"null pointer root passed\n");
    return NULL;
  } 
  xmlPathP=get_xml_elements(root,"field");
  if(xmlPathP==NULL){
    ERRORS(EINVAL,"no Fields found\n");
    return NULL;
  }
  field_set=xmlPathP->nodesetval;
  if(field_set->nodeNr){
    /** +1 to show the end */
    fields=malloc(sizeof(struct field_desc *)*(field_set->nodeNr+1));

    for(index=0;index<field_set->nodeNr && fields!=NULL;index++){
      fields[index]=calloc(0,sizeof(struct field_desc));
      if(fields[index]!=NULL){
        xmlNodePtr field=field_set->nodeTab[index];
        fields[index]->name=get_attribute_val(field,"name");
        tempC=get_attribute_val(field,"mask");
        fields[index]->mask=getNumArg((char*)tempC);
        if(tempC){
          xmlFree(tempC);
        }
        tempC=get_attribute_val(field,"def_val");
        fields[index]->def_val=getNumArg((char *)tempC);
        if(tempC){
          xmlFree(tempC);
        }
      }
     printf("FIELD %s mask=0x%08x def_val=[%x]\n",
          fields[index]->name, fields[index]->mask, fields[index]->def_val);
    }
    if(fields!=NULL){
      printf("\\0\n");
      fields[field_set->nodeNr]=NULL;
    }
  }
  xmlXPathFreeObject(xmlPathP);
  return fields;
}

struct register_desc * parse_register(xmlNodePtr root)
{
  xmlChar *s;
  unsigned int offset=0,size=0;
  struct register_desc *reg=NULL;
  if(root==NULL){
    ERRORS(EINVAL,"null pointer root passed\n");
    return NULL;
  } 
  //printf("parsing element %s\n",root->name);
  s=get_attribute_val(root,"offset");
  if(s){
    offset=getNumArg((char *)s);
    xmlFree(s);
  }
  s=get_attribute_val(root,"size");
  if(s){
    size=getNumArg((char *)s);
    xmlFree(s);
  }
  reg=calloc(0,sizeof(struct register_desc));
  if(reg){
    reg->size=size;
    reg->offset=offset;
    reg->name=get_attribute_val(root,"sym_name");
    reg->fields=NULL;
    //reg->fields=parse_register_field(root);
  }
  return reg;
}
void parse_registers(xmlNodePtr root)
{
  xmlXPathObjectPtr reg_path=NULL;
  xmlNodeSetPtr registers=NULL;
  struct register_desc **regs=NULL;
  int i=0,index=0;
  if(root==NULL){
    ERRORS(EINVAL,"null pointer root passed");
    return;
  }
  reg_path=get_xml_elements(root,"register");
  if(reg_path==NULL){
    ERROR("register definition not Found");
    return;
  }
  registers=reg_path->nodesetval;
  if(registers){
     DEBUG("Found %d register definitions\n",registers->nodeNr);
    if(registers->nodeNr>0){
      regs=malloc(sizeof(struct register_desc *)*registers->nodeNr);
        for(i=0;i<registers->nodeNr && regs!=NULL ;i++){
          regs[i]=parse_register(registers->nodeTab[i]);
          printf("----found REG[%s] offset=%08x size=%d\n",(char *)regs[i]->name,regs[i]->offset,regs[i]->size);
        }
    }
  }
  for(i=0;i<registers->nodeNr;i++){
      printf("found REG[%s] offset=%08x size=%d\n",(char *)regs[i]->name,regs[i]->offset,regs[i]->size);
      //for(index=0;regs[i]->fields[index];index++){
      //  printf("FIELD %s mask=0x%08x  def_val=%i\n",
      //      regs[i]->fields[index]->name, regs[i]->fields[index]->mask, regs[i]->fields[index]->def_val);
      //}
  }
  i=(registers->nodeNr-1);
  xmlXPathFreeObject(reg_path);
  for(;i>=0;i--){
    xmlFree(regs[i]->name);
    //for(index=0;regs[i]->fields[index];index++){
    //  xmlFree(regs[i]->fields[index]->name);
    //  free(regs[i]->fields[index]);
    //}
    //free(regs[i]->fields);
    free(regs[i]);
  }
  free(regs);
}


