@echo off

IF NOT EXIST scripts\xmlsec.bat echo ERROR: This script MUST run from the root directory!

IF "%1"=="win64" (
  set PLAT=win64
  call "%VS90COMNTOOLS%\..\..\VC\vcvarsall.bat" x86_amd64
) ELSE (
  set PLAT=win32
  call "%VS90COMNTOOLS%\..\..\VC\vcvarsall.bat" x86
)
@echo platform is %PLAT%

IF "%2"=="DEBUG" (
  set DBG=yes
  set PLAT=%PLAT%D
  set DEBUG=1
  @echo building Debug
) ELSE (
  set DBG=no
  @echo building Release
)

@echo set default variables
set VER=xmlsec1-1.2.16
set CUR_DIR=%cd%
IF NOT DEFINED SSL_DIR set SSL_DIR=%CUR_DIR%\..\install\%PLAT%
IF NOT DEFINED XML_DIR set XML_DIR=%SSL_DIR%

@echo setup log directory for %VER%
set LOG_DIR=%CUR_DIR%\logs
IF NOT EXIST %LOG_DIR% mkdir %LOG_DIR%
IF EXIST %LOG_DIR%\%VER%-%PLAT%*.log del %LOG_DIR%\%VER%-%PLAT%*.log

@echo set build directory
set TARG_DIR=%CUR_DIR%\build\%PLAT%
mkdir %TARG_DIR%
set BUILD_DIR=%TARG_DIR%\%VER%

@echo extract the source
cd %TARG_DIR%
IF NOT EXIST %BUILD_DIR% gzip -d -c %CUR_DIR%\%VER%.tar.gz | tar xvf - > %LOG_DIR%\%VER%-%PLAT%-extract.log

@echo set build variables
SET PREFIX=%CUR_DIR%\..\install\%PLAT%
SET XMLSEC_INCLUDE=%SSL_DIR%\include;%XML_DIR%\include;"%INCLUDE%"
SET XMLSEC_LIB=%SSL_DIR%\lib;%XML_DIR%\lib;"%LIB%"
SET XMLSEC_OPTIONS=static=no iconv=no debug=%DBG% xslt=yes crypto=mscrypto,openssl unicode=no
set PATH=%PREFIX%\bin;%PATH%

@echo configure %VER%
cd %BUILD_DIR%\win32\
copy /y %CUR_DIR%\scripts\xmlsec-Makefile.msvc %BUILD_DIR%\win32\Makefile.msvc
cscript configure.js prefix=%PREFIX% %XMLSEC_OPTIONS% include=%XMLSEC_INCLUDE% lib=%XMLSEC_LIB% > %LOG_DIR%\%VER%-%PLAT%-configure.log

@echo build %VER%
nmake -f Makefile.msvc clean > %LOG_DIR%\%VER%-%PLAT%-clean.log
nmake -f Makefile.msvc > %LOG_DIR%\%VER%-%PLAT%-build.log

@echo install %VER%
nmake install > %LOG_DIR%\%VER%-%PLAT%-install.log

IF "%2"=="DEBUG" (
  @echo copy .pdb files
  copy /y binaries\*.pdb %PREFIX%\lib\

  @echo embed debug manifest files
  cd %PREFIX%\bin
  mt.exe -manifest xmlsecD.exe.manifest -outputresource:xmlsecD.exe;1
  del *.manifest
  cd %PREFIX%\lib
  mt.exe -manifest libxmlsecD.dll.manifest -outputresource:libxmlsecD.dll;2
  mt.exe -manifest libxmlsec-mscryptoD.dll.manifest -outputresource:libxmlsec-mscryptoD.dll;2
  mt.exe -manifest libxmlsec-opensslD.dll.manifest -outputresource:libxmlsec-opensslD.dll;2
  del *.manifest
) ELSE (

  @echo embed release manifest files
  cd %PREFIX%\bin
  mt.exe -manifest xmlsec.exe.manifest -outputresource:xmlsec.exe;1
  del *.manifest
  cd %PREFIX%\lib
  mt.exe -manifest libxmlsec.dll.manifest -outputresource:libxmlsec.dll;2
  mt.exe -manifest libxmlsec-mscrypto.dll.manifest -outputresource:libxmlsec-mscrypto.dll;2
  mt.exe -manifest libxmlsec-openssl.dll.manifest -outputresource:libxmlsec-openssl.dll;2
  del *.manifest
)

@echo return to %CUR_DIR%
cd %CUR_DIR%
