#!/usr/local/bin/yade-trunk -x
# -*- encoding=utf-8 -*-

## Omega
o=Omega() 

from yade import utils
import random

## PhysicalParameters 
Young = 7e4
#Young = 15e4
Poisson = 0.3

def import_walls(file, begin=0, groupMask=1, import_vertices=True, import_edges=True, import_facets=True, facets_wire=True):
		## Import walls geometry from STL file
		imp = STLImporter()
		imp.import_vertices = import_vertices
		imp.import_edges = import_edges
		imp.import_facets = import_facets
		imp.facets_wire = facets_wire
		imp.open(file)
		o=Omega()
		for i in xrange(imp.number_of_all_imported):
			b=Body()
			b['isDynamic']=False
			b['groupMask']=groupMask
			b.phys=PhysicalParameters('BodyMacroParameters',{'se3':[0,0,0,1,0,0,0],'mass':0,'inertia':[0,0,0],'young':Young,'poisson':Poisson})
			if(i>=imp.number_of_imported_vertices):
					b.bound=BoundingVolume('AABB',{'diffuseColor':[0,1,0]})
			o.bodies.append(b)
		imp.import_geometry(o.bodies,begin)
		return imp.number_of_all_imported

imported=0
cylinder_begin=imported;imported+=import_walls('reactor-cylinder.stl',begin=imported);cylinder_end=imported
unloader_begin=imported;imported+=import_walls('reactor-unloader.stl',begin=imported);unloader_end=imported
imported+=import_walls('reactor-loader.stl',begin=imported)

## Spheres
sphereRadius = [0.005,0.01]
#nbSpheres = (17,32,17)
nbSpheres = (10,10,10)
disorder = 0.1
for i in xrange(nbSpheres[0]):
    for j in xrange(nbSpheres[1]):
			for k in xrange(nbSpheres[2]):
				x = (i*2 - nbSpheres[0])*sphereRadius[1]*1.1 + (random.random()*2-1)*disorder*sphereRadius[1]
				y = j*sphereRadius[1]*2.2 + 0.05 + (random.random()*2-1)*disorder*sphereRadius[1]
				z = (k*2 - nbSpheres[2])*sphereRadius[1]*1.1 + (random.random()*2-1)*disorder*sphereRadius[1]
				r = random.uniform(sphereRadius[0],sphereRadius[1])
				o.bodies.append(utils.sphere([x,y,z],r,young=Young,poisson=Poisson,density=1300,color=[75*r,0.29,0.25]))

## Timestep 
#o.dt=.2*utils.PWaveTimeStep()
#o.dt=1e-4
o.dt=1e-3
rec = 50 # rec frames/sec


## Initializers 
o.initializers=[
	## Create and reset to zero container of all PhysicalActions that will be used
	StandAloneEngine('PhysicalActionContainerInitializer'),
	## Create bounding boxes. They are needed to zoom the 3d view properly before we start the simulation.
	MetaEngine('BoundingVolumeMetaEngine',[EngineUnit('InteractingSphere2AABB'),EngineUnit('InteractingEdge2AABB'),EngineUnit('InteractingFacet2AABB'),EngineUnit('MetaInteractingGeometry2AABB'),EngineUnit('InteractingBox2AABB')])
	]

## Engines 
o.engines=[
	## Resets forces and momenta the act on bodies
	StandAloneEngine('PhysicalActionContainerReseter'),
	## Associates bounding volume to each body.
	MetaEngine('BoundingVolumeMetaEngine',[
		EngineUnit('InteractingSphere2AABB'),
		EngineUnit('InteractingEdge2AABB'),
		EngineUnit('InteractingFacet2AABB'),
		EngineUnit('InteractingBox2AABB'),
		EngineUnit('MetaInteractingGeometry2AABB')
	]),
	## Using bounding boxes find possible body collisions.
	#StandAloneEngine('SpatialQuickSortCollider'),
	StandAloneEngine('PersistentSAPCollider'),
	## Create geometry information about each potential collision.
	MetaEngine('InteractionGeometryMetaEngine',[
		EngineUnit('InteractingSphere2InteractingSphere4SpheresContactGeometry'),
		EngineUnit('InteractingVertex2InteractingSphere4SpheresContactGeometry'),
		EngineUnit('InteractingEdge2InteractingSphere4SpheresContactGeometry'),
		EngineUnit('InteractingFacet2InteractingSphere4SpheresContactGeometry'),
		EngineUnit('InteractingBox2InteractingSphere4SpheresContactGeometry'),
	]),
	## Create physical information about the interaction.
	MetaEngine('InteractionPhysicsMetaEngine',[EngineUnit('MacroMicroElasticRelationships')]),
	## "Solver" of the contact
	StandAloneEngine('ElasticContactLaw'),
	## Apply gravity
	DeusExMachina('GravityEngine',{'gravity':[0,-9.81,0]}),

	## Substitution PhysicalActionDamper, PhysicalActionApplier, NewtonsForceLaw, NewtonsMomentumLaw, LeapFrogPositionIntegrator, LeapFrogOrientationIntegrator
	DeusExMachina('NewtonsDampedLaw',{'damping':0.3}),

	## Reload unloading particles
	DeusExMachina('ResetPositionEngine',{'interval':1e4,'Y_min':-0.85,'subscribedBodies':range(imported,imported+nbSpheres[0]*nbSpheres[1]*nbSpheres[2])}),
	
	## Cylinder rotation
	DeusExMachina('RotationEngine',{'subscribedBodies':range(cylinder_begin,cylinder_end),'rotationAxis':[0.707,0.707,0],'rotateAroundZero':True,'zeroPoint':[-0.358,-0.490,0.003],'angularVelocity':1.047}),
	## Unloader rotation
	DeusExMachina('RotationEngine',{'subscribedBodies':range(unloader_begin,unloader_end),'rotationAxis':[0.707,0.707,0],'rotateAroundZero':True,'zeroPoint':[-0.558,-0.690,0.003],'angularVelocity':1.047}),
	
#	StandAloneEngine("PositionOrientationRecorder",{'outputFile':'./output/positions','interval':1.0/o.dt/rec})
]

o.save('/tmp/a.xml')
o.load('/tmp/a.xml')

