__version = '$ Release 0.0.1 $'[-7:-2]

# Copyright (c) 2001 Michael Bernstein
# All rights reserved. Written by Michael Bernstein webmaven@lvcm.com


from OFS.content_types    import guess_content_type
from OFS.Image            import Image, cookId, Pdata
from Globals              import HTMLFile, MessageDialog, Persistent, default__class_init__
from OFS.PropertyManager  import PropertyManager
from OFS.ObjectManager    import ObjectManager
from OFS.SimpleItem       import SimpleItem, Item_w__name__
from AccessControl.Role   import RoleManager
from webdav.common        import rfc1123_date
from cStringIO            import StringIO
from Acquisition          import Implicit
from DateTime             import DateTime
from types                import IntType, StringType, TupleType
from urllib               import quote, unquote
from OFS.FindSupport      import FindSupport
from PIL.Image            import BICUBIC, BILINEAR, NEAREST
from Products.ZPatterns.DataSkins import DataSkin

import Globals, string, struct, OFS.content_types
import PIL
from ComputedAttribute import ComputedAttribute

manage_addRackImageForm=HTMLFile('RackImageAdd', globals(), Kind='RackImage', kind='RackImage')

def manage_addRackImage(self, id, file, title='', content_type=None, REQUEST=None):
    """
    Add a new RackImage object.
    """
    id, title = cookId(id, title, file)
    self=self.this()
# First, we create the RackImage without data:
    self._setObject(id, RackImage(id))
# Then we initialize it with basic properties
    object=self._getOb(id)
    data, size = object._read_data(file)
    content_type=guess_content_type(data, id, content_type)
    object.manage_edit(title, content_type)

# Now we "upload" the data.  By doing this in two steps, we
# can use a database trick to make the upload more efficient.
    object.manage_upload(file)
    if REQUEST:
        try:    url=self.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect('%s/manage_main' % url)
    return id

class RackImage(DataSkin, Image):
    """
    RackImage objects are images. Each RackImage will save itself at a variety
    of display sizes for fast and easy retrieval from the web.
    """
    meta_type='RackImage'
    manage_displays=HTMLFile('displays',globals())
# Bad form to leave in commented code. 20000113-apl
# Shame on me. This ties in with another section below.
#    manage_resize=HTMLFile('resize',globals())
#    manage_transpose=HTMLFile('transpose',g2Qls())
    manage_options=({'label':'Edit', 'action':'manage_main'},
                    {'label':'Upload', 'action':'manage_uploadForm'},
                    {'label':'Properties', 'action':'manage_propertiesForm'},
                    {'label':'View', 'action':'view_image_or_file'},
                    {'label':'Security', 'action':'manage_access'},
                    )

    def __init__(self, id):
        RackImage.inheritedAttribute('__init__')(self, id)
        self.__dict__['__name__']=id

# What is the performance of the following? I suspect that this one section
# will affect performance more than anything....
    def __call__(self, REQUEST=None, alt=None):
    
        string = '<img src="%s" width="%s" height="%s"' % (
                self.absolute_url(), self.width, self.height
                )
        string = string +'>'
        return string 

    def update_data(self, data, content_type = None, size = None):
        """
        Replaces the current contents of the RackImage object with file.
        """
        Image.update_data(self, data, content_type, size)

Globals.default__class_init__(RackImage)

