__doc__    = """ RackImage Initialize """
__version__= '$ Release 0.0.1 $'[-7:-2]

import RackImage

def initialize(context): 
    """Initialize the RackImage product."""
    
    try: 
        context.registerClass(
            RackImage.RackImage,                   
        permission = 'Add Rack Images',
            constructors = (                 
                RackImage.manage_addRackImageForm, 
                RackImage.manage_addRackImage),    
            icon = 'RackImage.gif'                                             
            )
        context.registerBaseClass(RackImage.RackImage)

    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        sys.stderr.write(string.join(
                      traceback.format_exception(type, val, tb), ''))
        del type, val, tb

