from Products.ZSQLMethods.SQL import SQL

class GenerateInsert:
	def __init__(self, dbc, table_name, params):
		self.dbc = dbc
		self.table_name = table_name
		self.params = params
		
	def getParamNames(self):
		return ' '.join(self.params.keys())
		
	def getParamList(self):
		return ','.join(self.params.keys())
		
	def getValues(self):
		result = []
		for (key, value) in self.params.items():
			result.append('<dtml-sqlvar %s type="%s">' % (key, value))
		return ','.join(result)
	
	def generate(self):
		return SQL('insertID', '', self.dbc, self.getParamNames(),
			""" INSERT INTO %s
					(%s)
				VALUES
					(%s) 
			""" % (self.table_name, self.getParamList(), self.getValues())
		)