#!/usr/bin/python

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from unittest import main, TestSuite, makeSuite
#from Products.WebInterfaceTools.TestCase import WTestCase
from Testing.ZopeTestCase import ZopeTestCase

from Products.SimpleSQLTests.SimpleSQLTests import GenerateInsert

class SimpleSQLTestCase(ZopeTestCase):
	def _simplify(self, query_string):
		return query_string.replace(' ', '').replace('\n', '').replace('\t', '').lower()

	def testSimpleInsert(self):
		sql = GenerateInsert('dbc', 'aTable', {'param1': 'int'}).generate()
		self.assertEqual(sql.arguments_src, "param1")
		EXPECTED = """
            INSERT INTO aTable
                (param1)
            VALUES
                (<dtml-sqlvar param1 type="int">)
        """
		self.assertEqual(self._simplify(sql.src), self._simplify(EXPECTED))


def test_suite():
    suite = TestSuite()
    suite.addTest(makeSuite(SimpleSQLTestCase, 'test'))
    return suite


if __name__ == '__main__':
    main()

